@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.inputs

import com.pulumi.azurenative.videoanalyzer.inputs.VideoCreationPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Optional properties to be used in case a new video resource needs to be created on the service. These will not take effect if the video already exists.
 * @property description Optional description provided by the user. Value can be up to 2048 characters long.
 * @property retentionPeriod Video retention period indicates how long the video is kept in storage. Value must be specified in ISO8601 duration format (i.e. "P1D" equals 1 day) and can vary between 1 day to 10 years, in 1 day increments. When absent (null), all video content is retained indefinitely. This property is only allowed for topologies where "kind" is set to "live".
 * @property segmentLength Segment length indicates the length of individual content files (segments) which are persisted to storage. Smaller segments provide lower archive playback latency but generate larger volume of storage transactions. Larger segments reduce the amount of storage transactions while increasing the archive playback latency. Value must be specified in ISO8601 duration format (i.e. "PT30S" equals 30 seconds) and can vary between 30 seconds to 5 minutes, in 30 seconds increments. Changing this value after the initial call to create the video resource can lead to errors when uploading content to the archive. Default value is 30 seconds. This property is only allowed for topologies where "kind" is set to "live".
 * @property title Optional title provided by the user. Value can be up to 256 characters long.
 */
public data class VideoCreationPropertiesArgs(
    public val description: Output<String>? = null,
    public val retentionPeriod: Output<String>? = null,
    public val segmentLength: Output<String>? = null,
    public val title: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.inputs.VideoCreationPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.videoanalyzer.inputs.VideoCreationPropertiesArgs =
        com.pulumi.azurenative.videoanalyzer.inputs.VideoCreationPropertiesArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .retentionPeriod(retentionPeriod?.applyValue({ args0 -> args0 }))
            .segmentLength(segmentLength?.applyValue({ args0 -> args0 }))
            .title(title?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VideoCreationPropertiesArgs].
 */
@PulumiTagMarker
public class VideoCreationPropertiesArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var retentionPeriod: Output<String>? = null

    private var segmentLength: Output<String>? = null

    private var title: Output<String>? = null

    /**
     * @param value Optional description provided by the user. Value can be up to 2048 characters long.
     */
    @JvmName("booieqgrfuaxnqvc")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Video retention period indicates how long the video is kept in storage. Value must be specified in ISO8601 duration format (i.e. "P1D" equals 1 day) and can vary between 1 day to 10 years, in 1 day increments. When absent (null), all video content is retained indefinitely. This property is only allowed for topologies where "kind" is set to "live".
     */
    @JvmName("ijvgrkkdtsrooumj")
    public suspend fun retentionPeriod(`value`: Output<String>) {
        this.retentionPeriod = value
    }

    /**
     * @param value Segment length indicates the length of individual content files (segments) which are persisted to storage. Smaller segments provide lower archive playback latency but generate larger volume of storage transactions. Larger segments reduce the amount of storage transactions while increasing the archive playback latency. Value must be specified in ISO8601 duration format (i.e. "PT30S" equals 30 seconds) and can vary between 30 seconds to 5 minutes, in 30 seconds increments. Changing this value after the initial call to create the video resource can lead to errors when uploading content to the archive. Default value is 30 seconds. This property is only allowed for topologies where "kind" is set to "live".
     */
    @JvmName("gvikkfphaqrnofim")
    public suspend fun segmentLength(`value`: Output<String>) {
        this.segmentLength = value
    }

    /**
     * @param value Optional title provided by the user. Value can be up to 256 characters long.
     */
    @JvmName("yebixutootufnhnv")
    public suspend fun title(`value`: Output<String>) {
        this.title = value
    }

    /**
     * @param value Optional description provided by the user. Value can be up to 2048 characters long.
     */
    @JvmName("tpomfaickmxkvyyo")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Video retention period indicates how long the video is kept in storage. Value must be specified in ISO8601 duration format (i.e. "P1D" equals 1 day) and can vary between 1 day to 10 years, in 1 day increments. When absent (null), all video content is retained indefinitely. This property is only allowed for topologies where "kind" is set to "live".
     */
    @JvmName("pynyorvaqrvryhec")
    public suspend fun retentionPeriod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionPeriod = mapped
    }

    /**
     * @param value Segment length indicates the length of individual content files (segments) which are persisted to storage. Smaller segments provide lower archive playback latency but generate larger volume of storage transactions. Larger segments reduce the amount of storage transactions while increasing the archive playback latency. Value must be specified in ISO8601 duration format (i.e. "PT30S" equals 30 seconds) and can vary between 30 seconds to 5 minutes, in 30 seconds increments. Changing this value after the initial call to create the video resource can lead to errors when uploading content to the archive. Default value is 30 seconds. This property is only allowed for topologies where "kind" is set to "live".
     */
    @JvmName("cjwdqwmnnbheoqhd")
    public suspend fun segmentLength(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.segmentLength = mapped
    }

    /**
     * @param value Optional title provided by the user. Value can be up to 256 characters long.
     */
    @JvmName("btrfkreaegsymxui")
    public suspend fun title(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.title = mapped
    }

    internal fun build(): VideoCreationPropertiesArgs = VideoCreationPropertiesArgs(
        description = description,
        retentionPeriod = retentionPeriod,
        segmentLength = segmentLength,
        title = title,
    )
}
