@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.inputs

import com.pulumi.azurenative.videoanalyzer.inputs.VideoPublishingOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Optional flags used to change how video is published. These are only allowed for topologies where "kind" is set to "live".
 * @property disableArchive When set to 'true' content will not be archived or recorded. This is used, for example, when the topology is used only for low latency video streaming. Default is 'false'.  If set to 'true', then "disableRtspPublishing" must be set to 'false'.
 * @property disableRtspPublishing When set to 'true' the RTSP playback URL will not be published, disabling low latency streaming. This is used, for example, when the topology is used only for archiving content. Default is 'false'.  If set to 'true', then "disableArchive" must be set to 'false'.
 */
public data class VideoPublishingOptionsArgs(
    public val disableArchive: Output<String>? = null,
    public val disableRtspPublishing: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.inputs.VideoPublishingOptionsArgs> {
    override fun toJava(): com.pulumi.azurenative.videoanalyzer.inputs.VideoPublishingOptionsArgs =
        com.pulumi.azurenative.videoanalyzer.inputs.VideoPublishingOptionsArgs.builder()
            .disableArchive(disableArchive?.applyValue({ args0 -> args0 }))
            .disableRtspPublishing(disableRtspPublishing?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VideoPublishingOptionsArgs].
 */
@PulumiTagMarker
public class VideoPublishingOptionsArgsBuilder internal constructor() {
    private var disableArchive: Output<String>? = null

    private var disableRtspPublishing: Output<String>? = null

    /**
     * @param value When set to 'true' content will not be archived or recorded. This is used, for example, when the topology is used only for low latency video streaming. Default is 'false'.  If set to 'true', then "disableRtspPublishing" must be set to 'false'.
     */
    @JvmName("oxkctibvibklfekg")
    public suspend fun disableArchive(`value`: Output<String>) {
        this.disableArchive = value
    }

    /**
     * @param value When set to 'true' the RTSP playback URL will not be published, disabling low latency streaming. This is used, for example, when the topology is used only for archiving content. Default is 'false'.  If set to 'true', then "disableArchive" must be set to 'false'.
     */
    @JvmName("dssllgqibrnkvgin")
    public suspend fun disableRtspPublishing(`value`: Output<String>) {
        this.disableRtspPublishing = value
    }

    /**
     * @param value When set to 'true' content will not be archived or recorded. This is used, for example, when the topology is used only for low latency video streaming. Default is 'false'.  If set to 'true', then "disableRtspPublishing" must be set to 'false'.
     */
    @JvmName("lktbdjbmtxfkeokp")
    public suspend fun disableArchive(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableArchive = mapped
    }

    /**
     * @param value When set to 'true' the RTSP playback URL will not be published, disabling low latency streaming. This is used, for example, when the topology is used only for archiving content. Default is 'false'.  If set to 'true', then "disableArchive" must be set to 'false'.
     */
    @JvmName("ompcmkavyjvquupo")
    public suspend fun disableRtspPublishing(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableRtspPublishing = mapped
    }

    internal fun build(): VideoPublishingOptionsArgs = VideoPublishingOptionsArgs(
        disableArchive = disableArchive,
        disableRtspPublishing = disableRtspPublishing,
    )
}
