@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.inputs

import com.pulumi.azurenative.videoanalyzer.inputs.VideoScaleArgs.builder
import com.pulumi.azurenative.videoanalyzer.kotlin.enums.VideoScaleMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The video scaling information.
 * @property height The desired output video height.
 * @property mode Describes the video scaling mode to be applied. Default mode is 'Pad'. If the mode is 'Pad' or 'Stretch' then both width and height must be specified. Else if the mode is 'PreserveAspectRatio' then only one of width or height need be provided.
 * @property width The desired output video width.
 */
public data class VideoScaleArgs(
    public val height: Output<String>? = null,
    public val mode: Output<Either<String, VideoScaleMode>>? = null,
    public val width: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.inputs.VideoScaleArgs> {
    override fun toJava(): com.pulumi.azurenative.videoanalyzer.inputs.VideoScaleArgs =
        com.pulumi.azurenative.videoanalyzer.inputs.VideoScaleArgs.builder()
            .height(height?.applyValue({ args0 -> args0 }))
            .mode(
                mode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .width(width?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VideoScaleArgs].
 */
@PulumiTagMarker
public class VideoScaleArgsBuilder internal constructor() {
    private var height: Output<String>? = null

    private var mode: Output<Either<String, VideoScaleMode>>? = null

    private var width: Output<String>? = null

    /**
     * @param value The desired output video height.
     */
    @JvmName("oysffvevsimjxgrf")
    public suspend fun height(`value`: Output<String>) {
        this.height = value
    }

    /**
     * @param value Describes the video scaling mode to be applied. Default mode is 'Pad'. If the mode is 'Pad' or 'Stretch' then both width and height must be specified. Else if the mode is 'PreserveAspectRatio' then only one of width or height need be provided.
     */
    @JvmName("dwnnntcnthikcfkv")
    public suspend fun mode(`value`: Output<Either<String, VideoScaleMode>>) {
        this.mode = value
    }

    /**
     * @param value The desired output video width.
     */
    @JvmName("wdbhaoyvtmwwcrgp")
    public suspend fun width(`value`: Output<String>) {
        this.width = value
    }

    /**
     * @param value The desired output video height.
     */
    @JvmName("gaisbcktoadqytnx")
    public suspend fun height(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.height = mapped
    }

    /**
     * @param value Describes the video scaling mode to be applied. Default mode is 'Pad'. If the mode is 'Pad' or 'Stretch' then both width and height must be specified. Else if the mode is 'PreserveAspectRatio' then only one of width or height need be provided.
     */
    @JvmName("dlmbkfejexlvouno")
    public suspend fun mode(`value`: Either<String, VideoScaleMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Describes the video scaling mode to be applied. Default mode is 'Pad'. If the mode is 'Pad' or 'Stretch' then both width and height must be specified. Else if the mode is 'PreserveAspectRatio' then only one of width or height need be provided.
     */
    @JvmName("qrjitafaxmwhpfun")
    public fun mode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VideoScaleMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Describes the video scaling mode to be applied. Default mode is 'Pad'. If the mode is 'Pad' or 'Stretch' then both width and height must be specified. Else if the mode is 'PreserveAspectRatio' then only one of width or height need be provided.
     */
    @JvmName("islivdvnaiurbcvm")
    public fun mode(`value`: VideoScaleMode) {
        val toBeMapped = Either.ofRight<String, VideoScaleMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The desired output video width.
     */
    @JvmName("ycgphqsmdnjulqcw")
    public suspend fun width(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.width = mapped
    }

    internal fun build(): VideoScaleArgs = VideoScaleArgs(
        height = height,
        mode = mode,
        width = width,
    )
}
