@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.inputs

import com.pulumi.azurenative.videoanalyzer.inputs.VideoSinkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Video sink in a live topology allows for video and audio to be captured, optionally archived, and published via a video resource. If archiving is enabled, this results in a video of type 'archive'. If used in a batch topology, this allows for video and audio to be stored as a file, and published via a video resource of type 'file'
 * @property inputs An array of upstream node references within the topology to be used as inputs for this node.
 * @property name Node name. Must be unique within the topology.
 * @property type The discriminator for derived types.
 * Expected value is '#Microsoft.VideoAnalyzer.VideoSink'.
 * @property videoCreationProperties Optional video properties to be used in case a new video resource needs to be created on the service.
 * @property videoName Name of a new or existing video resource used to capture and publish content. Note: if downstream of RTSP source, and if disableArchive is set to true, then no content is archived.
 * @property videoPublishingOptions Options to change how the video sink publishes content via the video resource. This property is only allowed for topologies where "kind" is set to "live".
 */
public data class VideoSinkArgs(
    public val inputs: Output<List<NodeInputArgs>>,
    public val name: Output<String>,
    public val type: Output<String>,
    public val videoCreationProperties: Output<VideoCreationPropertiesArgs>? = null,
    public val videoName: Output<String>,
    public val videoPublishingOptions: Output<VideoPublishingOptionsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.inputs.VideoSinkArgs> {
    override fun toJava(): com.pulumi.azurenative.videoanalyzer.inputs.VideoSinkArgs =
        com.pulumi.azurenative.videoanalyzer.inputs.VideoSinkArgs.builder()
            .inputs(inputs.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .videoCreationProperties(
                videoCreationProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .videoName(videoName.applyValue({ args0 -> args0 }))
            .videoPublishingOptions(
                videoPublishingOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [VideoSinkArgs].
 */
@PulumiTagMarker
public class VideoSinkArgsBuilder internal constructor() {
    private var inputs: Output<List<NodeInputArgs>>? = null

    private var name: Output<String>? = null

    private var type: Output<String>? = null

    private var videoCreationProperties: Output<VideoCreationPropertiesArgs>? = null

    private var videoName: Output<String>? = null

    private var videoPublishingOptions: Output<VideoPublishingOptionsArgs>? = null

    /**
     * @param value An array of upstream node references within the topology to be used as inputs for this node.
     */
    @JvmName("vvthmcoubtyfpqfk")
    public suspend fun inputs(`value`: Output<List<NodeInputArgs>>) {
        this.inputs = value
    }

    @JvmName("kbdxvqnlhqnjbkvp")
    public suspend fun inputs(vararg values: Output<NodeInputArgs>) {
        this.inputs = Output.all(values.asList())
    }

    /**
     * @param values An array of upstream node references within the topology to be used as inputs for this node.
     */
    @JvmName("jwaqgotanihaophx")
    public suspend fun inputs(values: List<Output<NodeInputArgs>>) {
        this.inputs = Output.all(values)
    }

    /**
     * @param value Node name. Must be unique within the topology.
     */
    @JvmName("mabvhinlradwuyig")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.VideoAnalyzer.VideoSink'.
     */
    @JvmName("ddtvpckhouxivnti")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Optional video properties to be used in case a new video resource needs to be created on the service.
     */
    @JvmName("yxbvolkyvittfngs")
    public suspend fun videoCreationProperties(`value`: Output<VideoCreationPropertiesArgs>) {
        this.videoCreationProperties = value
    }

    /**
     * @param value Name of a new or existing video resource used to capture and publish content. Note: if downstream of RTSP source, and if disableArchive is set to true, then no content is archived.
     */
    @JvmName("pcoiejiqavscooee")
    public suspend fun videoName(`value`: Output<String>) {
        this.videoName = value
    }

    /**
     * @param value Options to change how the video sink publishes content via the video resource. This property is only allowed for topologies where "kind" is set to "live".
     */
    @JvmName("trcbowxqayclpnic")
    public suspend fun videoPublishingOptions(`value`: Output<VideoPublishingOptionsArgs>) {
        this.videoPublishingOptions = value
    }

    /**
     * @param value An array of upstream node references within the topology to be used as inputs for this node.
     */
    @JvmName("jvlrstxkbhqikuih")
    public suspend fun inputs(`value`: List<NodeInputArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputs = mapped
    }

    /**
     * @param argument An array of upstream node references within the topology to be used as inputs for this node.
     */
    @JvmName("pcxbrrkgaeosgdqu")
    public suspend fun inputs(argument: List<suspend NodeInputArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { NodeInputArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.inputs = mapped
    }

    /**
     * @param argument An array of upstream node references within the topology to be used as inputs for this node.
     */
    @JvmName("gaiyynjrjbndjjas")
    public suspend fun inputs(vararg argument: suspend NodeInputArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { NodeInputArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.inputs = mapped
    }

    /**
     * @param argument An array of upstream node references within the topology to be used as inputs for this node.
     */
    @JvmName("cahwdjgykggllhud")
    public suspend fun inputs(argument: suspend NodeInputArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(NodeInputArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.inputs = mapped
    }

    /**
     * @param values An array of upstream node references within the topology to be used as inputs for this node.
     */
    @JvmName("uyfxtjdxhellqcpn")
    public suspend fun inputs(vararg values: NodeInputArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputs = mapped
    }

    /**
     * @param value Node name. Must be unique within the topology.
     */
    @JvmName("yjahykckeojnfnhi")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.VideoAnalyzer.VideoSink'.
     */
    @JvmName("oivjlotjcygkxywh")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Optional video properties to be used in case a new video resource needs to be created on the service.
     */
    @JvmName("ldxfeqjboovwucjs")
    public suspend fun videoCreationProperties(`value`: VideoCreationPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.videoCreationProperties = mapped
    }

    /**
     * @param argument Optional video properties to be used in case a new video resource needs to be created on the service.
     */
    @JvmName("robvkotqdkldwoqu")
    public suspend
    fun videoCreationProperties(argument: suspend VideoCreationPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = VideoCreationPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.videoCreationProperties = mapped
    }

    /**
     * @param value Name of a new or existing video resource used to capture and publish content. Note: if downstream of RTSP source, and if disableArchive is set to true, then no content is archived.
     */
    @JvmName("wdebvuccjvojwedb")
    public suspend fun videoName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.videoName = mapped
    }

    /**
     * @param value Options to change how the video sink publishes content via the video resource. This property is only allowed for topologies where "kind" is set to "live".
     */
    @JvmName("rdbpopxgaxuvmugn")
    public suspend fun videoPublishingOptions(`value`: VideoPublishingOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.videoPublishingOptions = mapped
    }

    /**
     * @param argument Options to change how the video sink publishes content via the video resource. This property is only allowed for topologies where "kind" is set to "live".
     */
    @JvmName("vhlliehvgqnkhrvu")
    public suspend
    fun videoPublishingOptions(argument: suspend VideoPublishingOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = VideoPublishingOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.videoPublishingOptions = mapped
    }

    internal fun build(): VideoSinkArgs = VideoSinkArgs(
        inputs = inputs ?: throw PulumiNullFieldException("inputs"),
        name = name ?: throw PulumiNullFieldException("name"),
        type = type ?: throw PulumiNullFieldException("type"),
        videoCreationProperties = videoCreationProperties,
        videoName = videoName ?: throw PulumiNullFieldException("videoName"),
        videoPublishingOptions = videoPublishingOptions,
    )
}
