@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The details for accessing the encryption keys in Key Vault.
 * @property currentKeyIdentifier The current key used to encrypt Video Analyzer account, including the key version.
 * @property keyIdentifier The URL of the Key Vault key used to encrypt the account. The key may either be versioned (for example https://vault/keys/mykey/version1) or reference a key without a version (for example https://vault/keys/mykey).
 */
public data class KeyVaultPropertiesResponse(
    public val currentKeyIdentifier: String,
    public val keyIdentifier: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.KeyVaultPropertiesResponse):
            KeyVaultPropertiesResponse = KeyVaultPropertiesResponse(
            currentKeyIdentifier = javaType.currentKeyIdentifier(),
            keyIdentifier = javaType.keyIdentifier(),
        )
    }
}
