@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Provisioning token properties. A provisioning token allows for a single instance of Azure Video analyzer IoT edge module to be initialized and authorized to the cloud account. The provisioning token itself is short lived and it is only used for the initial handshake between IoT edge module and the cloud. After the initial handshake, the IoT edge module will agree on a set of authentication keys which will be auto-rotated as long as the module is able to periodically connect to the cloud. A new provisioning token can be generated for the same IoT edge module in case the module state lost or reset.
 * @property expirationDate The expiration date of the registration token. The Azure Video Analyzer IoT edge module must be initialized and connected to the Internet prior to the token expiration date.
 * @property token The token blob to be provided to the Azure Video Analyzer IoT edge module through the Azure IoT Edge module twin properties.
 */
public data class ListEdgeModuleProvisioningTokenResult(
    public val expirationDate: String,
    public val token: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.ListEdgeModuleProvisioningTokenResult):
            ListEdgeModuleProvisioningTokenResult = ListEdgeModuleProvisioningTokenResult(
            expirationDate = javaType.expirationDate(),
            token = javaType.token(),
        )
    }
}
