@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * "Video content token grants access to the video content URLs."
 * @property expirationDate The content token expiration date in ISO8601 format (eg. 2021-01-01T00:00:00Z).
 * @property token The content token value to be added to the video content URL as the value for the "token" query string parameter. The token is specific to a single video.
 */
public data class ListVideoContentTokenResult(
    public val expirationDate: String,
    public val token: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.ListVideoContentTokenResult):
            ListVideoContentTokenResult = ListVideoContentTokenResult(
            expirationDate = javaType.expirationDate(),
            token = javaType.token(),
        )
    }
}
