@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A remote tunnel securely established using IoT Hub device information.
 * @property deviceId The IoT device id to use when establishing the remote tunnel. This string is case-sensitive.
 * @property iotHubName Name of the IoT Hub.
 * @property type The discriminator for derived types.
 * Expected value is '#Microsoft.VideoAnalyzer.SecureIotDeviceRemoteTunnel'.
 */
public data class SecureIotDeviceRemoteTunnelResponse(
    public val deviceId: String,
    public val iotHubName: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.SecureIotDeviceRemoteTunnelResponse):
            SecureIotDeviceRemoteTunnelResponse = SecureIotDeviceRemoteTunnelResponse(
            deviceId = javaType.deviceId(),
            iotHubName = javaType.iotHubName(),
            type = javaType.type(),
        )
    }
}
