@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Options for controlling the validation of TLS endpoints.
 * @property ignoreHostname When set to 'true' causes the certificate subject name validation to be skipped. Default is 'false'.
 * @property ignoreSignature When set to 'true' causes the certificate chain trust validation to be skipped. Default is 'false'.
 */
public data class TlsValidationOptionsResponse(
    public val ignoreHostname: String? = null,
    public val ignoreSignature: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.TlsValidationOptionsResponse):
            TlsValidationOptionsResponse = TlsValidationOptionsResponse(
            ignoreHostname = javaType.ignoreHostname().map({ args0 -> args0 }).orElse(null),
            ignoreSignature = javaType.ignoreSignature().map({ args0 -> args0 }).orElse(null),
        )
    }
}
