@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The managed identity for the Video Analyzer resource.
 * @property type The identity type.
 * @property userAssignedIdentities The User Assigned Managed Identities.
 */
public data class VideoAnalyzerIdentityResponse(
    public val type: String,
    public val userAssignedIdentities: Map<String, UserAssignedManagedIdentityResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.VideoAnalyzerIdentityResponse):
            VideoAnalyzerIdentityResponse = VideoAnalyzerIdentityResponse(
            type = javaType.type(),
            userAssignedIdentities = javaType.userAssignedIdentities().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.videoanalyzer.kotlin.outputs.UserAssignedManagedIdentityResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
        )
    }
}
