@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The video scaling information.
 * @property height The desired output video height.
 * @property mode Describes the video scaling mode to be applied. Default mode is 'Pad'. If the mode is 'Pad' or 'Stretch' then both width and height must be specified. Else if the mode is 'PreserveAspectRatio' then only one of width or height need be provided.
 * @property width The desired output video width.
 */
public data class VideoScaleResponse(
    public val height: String? = null,
    public val mode: String? = null,
    public val width: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.VideoScaleResponse):
            VideoScaleResponse = VideoScaleResponse(
            height = javaType.height().map({ args0 -> args0 }).orElse(null),
            mode = javaType.mode().map({ args0 -> args0 }).orElse(null),
            width = javaType.width().map({ args0 -> args0 }).orElse(null),
        )
    }
}
