@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A sequence of absolute datetime ranges as a string. The datetime values should follow IS08601, and the sum of the ranges should add up to 24 hours or less. Currently, there can be only one range specified in the sequence.
 * @property ranges The sequence of datetime ranges. Example: '[["2021-10-05T03:30:00Z", "2021-10-05T03:40:00Z"]]'.
 * @property type The discriminator for derived types.
 * Expected value is '#Microsoft.VideoAnalyzer.VideoSequenceAbsoluteTimeMarkers'.
 */
public data class VideoSequenceAbsoluteTimeMarkersResponse(
    public val ranges: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.VideoSequenceAbsoluteTimeMarkersResponse):
            VideoSequenceAbsoluteTimeMarkersResponse = VideoSequenceAbsoluteTimeMarkersResponse(
            ranges = javaType.ranges(),
            type = javaType.type(),
        )
    }
}
