@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Video sink in a live topology allows for video and audio to be captured, optionally archived, and published via a video resource. If archiving is enabled, this results in a video of type 'archive'. If used in a batch topology, this allows for video and audio to be stored as a file, and published via a video resource of type 'file'
 * @property inputs An array of upstream node references within the topology to be used as inputs for this node.
 * @property name Node name. Must be unique within the topology.
 * @property type The discriminator for derived types.
 * Expected value is '#Microsoft.VideoAnalyzer.VideoSink'.
 * @property videoCreationProperties Optional video properties to be used in case a new video resource needs to be created on the service.
 * @property videoName Name of a new or existing video resource used to capture and publish content. Note: if downstream of RTSP source, and if disableArchive is set to true, then no content is archived.
 * @property videoPublishingOptions Options to change how the video sink publishes content via the video resource. This property is only allowed for topologies where "kind" is set to "live".
 */
public data class VideoSinkResponse(
    public val inputs: List<NodeInputResponse>,
    public val name: String,
    public val type: String,
    public val videoCreationProperties: VideoCreationPropertiesResponse? = null,
    public val videoName: String,
    public val videoPublishingOptions: VideoPublishingOptionsResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.VideoSinkResponse):
            VideoSinkResponse = VideoSinkResponse(
            inputs = javaType.inputs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.videoanalyzer.kotlin.outputs.NodeInputResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            type = javaType.type(),
            videoCreationProperties = javaType.videoCreationProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.videoanalyzer.kotlin.outputs.VideoCreationPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            videoName = javaType.videoName(),
            videoPublishingOptions = javaType.videoPublishingOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.videoanalyzer.kotlin.outputs.VideoPublishingOptionsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
