@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Video source allows for content from a Video Analyzer video resource to be ingested into a pipeline. Currently supported only with batch pipelines.
 * @property name Node name. Must be unique within the topology.
 * @property timeSequences Describes a sequence of datetime ranges. The video source only picks up recorded media within these ranges.
 * @property type The discriminator for derived types.
 * Expected value is '#Microsoft.VideoAnalyzer.VideoSource'.
 * @property videoName Name of the Video Analyzer video resource to be used as the source.
 */
public data class VideoSourceResponse(
    public val name: String,
    public val timeSequences: VideoSequenceAbsoluteTimeMarkersResponse,
    public val type: String,
    public val videoName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.VideoSourceResponse):
            VideoSourceResponse = VideoSourceResponse(
            name = javaType.name(),
            timeSequences = javaType.timeSequences().let({ args0 ->
                com.pulumi.azurenative.videoanalyzer.kotlin.outputs.VideoSequenceAbsoluteTimeMarkersResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            videoName = javaType.videoName(),
        )
    }
}
