@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoindexer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The media services details
 * @property resourceId The media services resource id
 * @property userAssignedIdentity The user assigned identity to be used to grant permissions
 */
public data class MediaServicesForPutRequestResponse(
    public val resourceId: String? = null,
    public val userAssignedIdentity: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.videoindexer.outputs.MediaServicesForPutRequestResponse):
            MediaServicesForPutRequestResponse = MediaServicesForPutRequestResponse(
            resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
            userAssignedIdentity = javaType.userAssignedIdentity().map({ args0 -> args0 }).orElse(null),
        )
    }
}
