@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin

import com.pulumi.azurenative.virtualmachineimages.kotlin.outputs.ImageTemplateIdentityResponse
import com.pulumi.azurenative.virtualmachineimages.kotlin.outputs.ImageTemplateLastRunStatusResponse
import com.pulumi.azurenative.virtualmachineimages.kotlin.outputs.ImageTemplatePropertiesResponseOptimize
import com.pulumi.azurenative.virtualmachineimages.kotlin.outputs.ImageTemplatePropertiesResponseValidate
import com.pulumi.azurenative.virtualmachineimages.kotlin.outputs.ImageTemplateVmProfileResponse
import com.pulumi.azurenative.virtualmachineimages.kotlin.outputs.ProvisioningErrorResponse
import com.pulumi.azurenative.virtualmachineimages.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.virtualmachineimages.kotlin.outputs.ImageTemplateIdentityResponse.Companion.toKotlin as imageTemplateIdentityResponseToKotlin
import com.pulumi.azurenative.virtualmachineimages.kotlin.outputs.ImageTemplateLastRunStatusResponse.Companion.toKotlin as imageTemplateLastRunStatusResponseToKotlin
import com.pulumi.azurenative.virtualmachineimages.kotlin.outputs.ImageTemplatePropertiesResponseOptimize.Companion.toKotlin as imageTemplatePropertiesResponseOptimizeToKotlin
import com.pulumi.azurenative.virtualmachineimages.kotlin.outputs.ImageTemplatePropertiesResponseValidate.Companion.toKotlin as imageTemplatePropertiesResponseValidateToKotlin
import com.pulumi.azurenative.virtualmachineimages.kotlin.outputs.ImageTemplateVmProfileResponse.Companion.toKotlin as imageTemplateVmProfileResponseToKotlin
import com.pulumi.azurenative.virtualmachineimages.kotlin.outputs.ProvisioningErrorResponse.Companion.toKotlin as provisioningErrorResponseToKotlin
import com.pulumi.azurenative.virtualmachineimages.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [VirtualMachineImageTemplate].
 */
@PulumiTagMarker
public class VirtualMachineImageTemplateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualMachineImageTemplateArgs = VirtualMachineImageTemplateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualMachineImageTemplateArgsBuilder.() -> Unit) {
        val builder = VirtualMachineImageTemplateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VirtualMachineImageTemplate {
        val builtJavaResource =
            com.pulumi.azurenative.virtualmachineimages.VirtualMachineImageTemplate(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VirtualMachineImageTemplate(builtJavaResource)
    }
}

/**
 * Image template is an ARM resource managed by Microsoft.VirtualMachineImages provider
 * Azure REST API version: 2022-07-01. Prior API version in Azure Native 1.x: 2020-02-14.
 * Other available API versions: 2018-02-01-preview, 2019-05-01-preview, 2023-07-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:virtualmachineimages:VirtualMachineImageTemplate myImageTemplate /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.VirtualMachineImages/imageTemplates/{imageTemplateName}
 * ```
 */
public class VirtualMachineImageTemplate internal constructor(
    override val javaResource:
    com.pulumi.azurenative.virtualmachineimages.VirtualMachineImageTemplate,
) : KotlinCustomResource(javaResource, VirtualMachineImageTemplateMapper) {
    /**
     * Maximum duration to wait while building the image template (includes all customizations, optimization, validations, and distributions). Omit or specify 0 to use the default (4 hours).
     */
    public val buildTimeoutInMinutes: Output<Int>?
        get() = javaResource.buildTimeoutInMinutes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the properties used to describe the customization steps of the image, like Image source etc
     */
    public val customize: Output<List<Any>>?
        get() = javaResource.customize().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The distribution targets where the image output needs to go to.
     */
    public val distribute: Output<List<Any>>
        get() = javaResource.distribute().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The staging resource group id in the same subscription as the image template that will be used to build the image. This read-only field differs from 'stagingResourceGroup' only if the value specified in the 'stagingResourceGroup' field is empty.
     */
    public val exactStagingResourceGroup: Output<String>
        get() = javaResource.exactStagingResourceGroup().applyValue({ args0 -> args0 })

    /**
     * The identity of the image template, if configured.
     */
    public val identity: Output<ImageTemplateIdentityResponse>
        get() = javaResource.identity().applyValue({ args0 ->
            args0.let({ args0 ->
                imageTemplateIdentityResponseToKotlin(args0)
            })
        })

    /**
     * State of 'run' that is currently executing or was last executed.
     */
    public val lastRunStatus: Output<ImageTemplateLastRunStatusResponse>
        get() = javaResource.lastRunStatus().applyValue({ args0 ->
            args0.let({ args0 ->
                imageTemplateLastRunStatusResponseToKotlin(args0)
            })
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Specifies optimization to be performed on image.
     */
    public val optimize: Output<ImageTemplatePropertiesResponseOptimize>?
        get() = javaResource.optimize().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    imageTemplatePropertiesResponseOptimizeToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Provisioning error, if any
     */
    public val provisioningError: Output<ProvisioningErrorResponse>
        get() = javaResource.provisioningError().applyValue({ args0 ->
            args0.let({ args0 ->
                provisioningErrorResponseToKotlin(args0)
            })
        })

    /**
     * Provisioning state of the resource
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Specifies the properties used to describe the source image.
     */
    public val source: Output<Any>
        get() = javaResource.source().applyValue({ args0 -> args0 })

    /**
     * The staging resource group id in the same subscription as the image template that will be used to build the image. If this field is empty, a resource group with a random name will be created. If the resource group specified in this field doesn't exist, it will be created with the same name. If the resource group specified exists, it must be empty and in the same region as the image template. The resource group created will be deleted during template deletion if this field is empty or the resource group specified doesn't exist, but if the resource group specified exists the resources created in the resource group will be deleted during template deletion and the resource group itself will remain.
     */
    public val stagingResourceGroup: Output<String>?
        get() = javaResource.stagingResourceGroup().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Configuration options and list of validations to be performed on the resulting image.
     */
    public val validate: Output<ImageTemplatePropertiesResponseValidate>?
        get() = javaResource.validate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    imageTemplatePropertiesResponseValidateToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Describes how virtual machine is set up to build images
     */
    public val vmProfile: Output<ImageTemplateVmProfileResponse>?
        get() = javaResource.vmProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    imageTemplateVmProfileResponseToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object VirtualMachineImageTemplateMapper : ResourceMapper<VirtualMachineImageTemplate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.virtualmachineimages.VirtualMachineImageTemplate::class == javaResource::class

    override fun map(javaResource: Resource): VirtualMachineImageTemplate =
        VirtualMachineImageTemplate(
            javaResource as
                com.pulumi.azurenative.virtualmachineimages.VirtualMachineImageTemplate,
        )
}

/**
 * @see [VirtualMachineImageTemplate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualMachineImageTemplate].
 */
public suspend fun virtualMachineImageTemplate(
    name: String,
    block: suspend VirtualMachineImageTemplateResourceBuilder.() -> Unit,
):
    VirtualMachineImageTemplate {
    val builder = VirtualMachineImageTemplateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualMachineImageTemplate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualMachineImageTemplate(name: String): VirtualMachineImageTemplate {
    val builder = VirtualMachineImageTemplateResourceBuilder()
    builder.name(name)
    return builder.build()
}
