@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.inputs

import com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateFileValidatorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Uploads files required for validation to VMs (Linux, Windows). Corresponds to Packer file provisioner
 * @property destination The absolute path to a file (with nested directory structures already created) where the file (from sourceUri) will be uploaded to in the VM
 * @property name Friendly Name to provide context on what this validation step does
 * @property sha256Checksum SHA256 checksum of the file provided in the sourceUri field above
 * @property sourceUri The URI of the file to be uploaded to the VM for validation. It can be a github link, Azure Storage URI (authorized or SAS), etc
 * @property type The type of validation you want to use on the Image. For example, "Shell" can be shell validation
 * Expected value is 'File'.
 */
public data class ImageTemplateFileValidatorArgs(
    public val destination: Output<String>? = null,
    public val name: Output<String>? = null,
    public val sha256Checksum: Output<String>? = null,
    public val sourceUri: Output<String>? = null,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateFileValidatorArgs> {
    override fun toJava():
        com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateFileValidatorArgs =
        com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateFileValidatorArgs.builder()
            .destination(destination?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .sha256Checksum(sha256Checksum?.applyValue({ args0 -> args0 }))
            .sourceUri(sourceUri?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageTemplateFileValidatorArgs].
 */
@PulumiTagMarker
public class ImageTemplateFileValidatorArgsBuilder internal constructor() {
    private var destination: Output<String>? = null

    private var name: Output<String>? = null

    private var sha256Checksum: Output<String>? = null

    private var sourceUri: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The absolute path to a file (with nested directory structures already created) where the file (from sourceUri) will be uploaded to in the VM
     */
    @JvmName("yrwojhhmifrcctdi")
    public suspend fun destination(`value`: Output<String>) {
        this.destination = value
    }

    /**
     * @param value Friendly Name to provide context on what this validation step does
     */
    @JvmName("yeoocjjbkahmqppu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value SHA256 checksum of the file provided in the sourceUri field above
     */
    @JvmName("elwgsiamshftavpr")
    public suspend fun sha256Checksum(`value`: Output<String>) {
        this.sha256Checksum = value
    }

    /**
     * @param value The URI of the file to be uploaded to the VM for validation. It can be a github link, Azure Storage URI (authorized or SAS), etc
     */
    @JvmName("brunpvijajjlfyhc")
    public suspend fun sourceUri(`value`: Output<String>) {
        this.sourceUri = value
    }

    /**
     * @param value The type of validation you want to use on the Image. For example, "Shell" can be shell validation
     * Expected value is 'File'.
     */
    @JvmName("uuvwahegfdnttksu")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The absolute path to a file (with nested directory structures already created) where the file (from sourceUri) will be uploaded to in the VM
     */
    @JvmName("mtiodxhajqabiqxy")
    public suspend fun destination(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param value Friendly Name to provide context on what this validation step does
     */
    @JvmName("uvlckbcjtuyhpigm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value SHA256 checksum of the file provided in the sourceUri field above
     */
    @JvmName("hsacvmbcovphjnyf")
    public suspend fun sha256Checksum(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sha256Checksum = mapped
    }

    /**
     * @param value The URI of the file to be uploaded to the VM for validation. It can be a github link, Azure Storage URI (authorized or SAS), etc
     */
    @JvmName("vyholrfoysaeoixa")
    public suspend fun sourceUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceUri = mapped
    }

    /**
     * @param value The type of validation you want to use on the Image. For example, "Shell" can be shell validation
     * Expected value is 'File'.
     */
    @JvmName("sipowucoblvvkogc")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ImageTemplateFileValidatorArgs = ImageTemplateFileValidatorArgs(
        destination = destination,
        name = name,
        sha256Checksum = sha256Checksum,
        sourceUri = sourceUri,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
