@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.inputs

import com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateManagedImageDistributorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Distribute as a Managed Disk Image.
 * @property artifactTags Tags that will be applied to the artifact once it has been created/updated by the distributor.
 * @property imageId Resource Id of the Managed Disk Image
 * @property location Azure location for the image, should match if image already exists
 * @property runOutputName The name to be used for the associated RunOutput.
 * @property type Type of distribution.
 * Expected value is 'ManagedImage'.
 */
public data class ImageTemplateManagedImageDistributorArgs(
    public val artifactTags: Output<Map<String, String>>? = null,
    public val imageId: Output<String>,
    public val location: Output<String>,
    public val runOutputName: Output<String>,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateManagedImageDistributorArgs> {
    override fun toJava():
        com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateManagedImageDistributorArgs =
        com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateManagedImageDistributorArgs.builder()
            .artifactTags(
                artifactTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .imageId(imageId.applyValue({ args0 -> args0 }))
            .location(location.applyValue({ args0 -> args0 }))
            .runOutputName(runOutputName.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageTemplateManagedImageDistributorArgs].
 */
@PulumiTagMarker
public class ImageTemplateManagedImageDistributorArgsBuilder internal constructor() {
    private var artifactTags: Output<Map<String, String>>? = null

    private var imageId: Output<String>? = null

    private var location: Output<String>? = null

    private var runOutputName: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Tags that will be applied to the artifact once it has been created/updated by the distributor.
     */
    @JvmName("ftxdxfvqwbysujuq")
    public suspend fun artifactTags(`value`: Output<Map<String, String>>) {
        this.artifactTags = value
    }

    /**
     * @param value Resource Id of the Managed Disk Image
     */
    @JvmName("lylrmjwduifikrhr")
    public suspend fun imageId(`value`: Output<String>) {
        this.imageId = value
    }

    /**
     * @param value Azure location for the image, should match if image already exists
     */
    @JvmName("fjscbawfcmjyarlv")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name to be used for the associated RunOutput.
     */
    @JvmName("bmiexfqxmrxyvgue")
    public suspend fun runOutputName(`value`: Output<String>) {
        this.runOutputName = value
    }

    /**
     * @param value Type of distribution.
     * Expected value is 'ManagedImage'.
     */
    @JvmName("otfthprqctcysjdw")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Tags that will be applied to the artifact once it has been created/updated by the distributor.
     */
    @JvmName("rtuvbrxpgienshjd")
    public suspend fun artifactTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifactTags = mapped
    }

    /**
     * @param values Tags that will be applied to the artifact once it has been created/updated by the distributor.
     */
    @JvmName("ewweajtwihpnltcb")
    public fun artifactTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.artifactTags = mapped
    }

    /**
     * @param value Resource Id of the Managed Disk Image
     */
    @JvmName("smstmnhoetniinub")
    public suspend fun imageId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.imageId = mapped
    }

    /**
     * @param value Azure location for the image, should match if image already exists
     */
    @JvmName("tqnlrgxpifilqvhy")
    public suspend fun location(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name to be used for the associated RunOutput.
     */
    @JvmName("wqeoswwbivixwblt")
    public suspend fun runOutputName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.runOutputName = mapped
    }

    /**
     * @param value Type of distribution.
     * Expected value is 'ManagedImage'.
     */
    @JvmName("kwrjhpxwtibntrlf")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ImageTemplateManagedImageDistributorArgs =
        ImageTemplateManagedImageDistributorArgs(
            artifactTags = artifactTags,
            imageId = imageId ?: throw PulumiNullFieldException("imageId"),
            location = location ?: throw PulumiNullFieldException("location"),
            runOutputName = runOutputName ?: throw PulumiNullFieldException("runOutputName"),
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
