@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.inputs

import com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateManagedImageSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes an image source that is a managed image in customer subscription. This image must reside in the same subscription and region as the Image Builder template.
 * @property imageId ARM resource id of the managed image in customer subscription
 * @property type Specifies the type of source image you want to start with.
 * Expected value is 'ManagedImage'.
 */
public data class ImageTemplateManagedImageSourceArgs(
    public val imageId: Output<String>,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateManagedImageSourceArgs> {
    override fun toJava():
        com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateManagedImageSourceArgs =
        com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateManagedImageSourceArgs.builder()
            .imageId(imageId.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageTemplateManagedImageSourceArgs].
 */
@PulumiTagMarker
public class ImageTemplateManagedImageSourceArgsBuilder internal constructor() {
    private var imageId: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value ARM resource id of the managed image in customer subscription
     */
    @JvmName("kxwekyyjnedtuwgi")
    public suspend fun imageId(`value`: Output<String>) {
        this.imageId = value
    }

    /**
     * @param value Specifies the type of source image you want to start with.
     * Expected value is 'ManagedImage'.
     */
    @JvmName("wvvvqimpmlhjdwlv")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value ARM resource id of the managed image in customer subscription
     */
    @JvmName("bqscwlgnmavteooy")
    public suspend fun imageId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.imageId = mapped
    }

    /**
     * @param value Specifies the type of source image you want to start with.
     * Expected value is 'ManagedImage'.
     */
    @JvmName("hvynorhdvwkbbwyh")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ImageTemplateManagedImageSourceArgs = ImageTemplateManagedImageSourceArgs(
        imageId = imageId ?: throw PulumiNullFieldException("imageId"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
