@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.inputs

import com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateSharedImageVersionSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes an image source that is an image version in an Azure Compute Gallery or a Direct Shared Gallery.
 * @property imageVersionId ARM resource id of the image version. When image version name is 'latest', the version is evaluated when the image build takes place.
 * @property type Specifies the type of source image you want to start with.
 * Expected value is 'SharedImageVersion'.
 */
public data class ImageTemplateSharedImageVersionSourceArgs(
    public val imageVersionId: Output<String>,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateSharedImageVersionSourceArgs> {
    override fun toJava():
        com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateSharedImageVersionSourceArgs =
        com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateSharedImageVersionSourceArgs.builder()
            .imageVersionId(imageVersionId.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageTemplateSharedImageVersionSourceArgs].
 */
@PulumiTagMarker
public class ImageTemplateSharedImageVersionSourceArgsBuilder internal constructor() {
    private var imageVersionId: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value ARM resource id of the image version. When image version name is 'latest', the version is evaluated when the image build takes place.
     */
    @JvmName("ydovnitrkbjijejb")
    public suspend fun imageVersionId(`value`: Output<String>) {
        this.imageVersionId = value
    }

    /**
     * @param value Specifies the type of source image you want to start with.
     * Expected value is 'SharedImageVersion'.
     */
    @JvmName("klabqjmsatkvcnpf")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value ARM resource id of the image version. When image version name is 'latest', the version is evaluated when the image build takes place.
     */
    @JvmName("mxvlfgtsycqucfft")
    public suspend fun imageVersionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.imageVersionId = mapped
    }

    /**
     * @param value Specifies the type of source image you want to start with.
     * Expected value is 'SharedImageVersion'.
     */
    @JvmName("whxwvdfnyvnbcwak")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ImageTemplateSharedImageVersionSourceArgs =
        ImageTemplateSharedImageVersionSourceArgs(
            imageVersionId = imageVersionId ?: throw PulumiNullFieldException("imageVersionId"),
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
