@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.inputs

import com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateVhdDistributorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Distribute via VHD in a storage account.
 * @property artifactTags Tags that will be applied to the artifact once it has been created/updated by the distributor.
 * @property runOutputName The name to be used for the associated RunOutput.
 * @property type Type of distribution.
 * Expected value is 'VHD'.
 * @property uri Optional Azure Storage URI for the distributed VHD blob. Omit to use the default (empty string) in which case VHD would be published to the storage account in the staging resource group.
 */
public data class ImageTemplateVhdDistributorArgs(
    public val artifactTags: Output<Map<String, String>>? = null,
    public val runOutputName: Output<String>,
    public val type: Output<String>,
    public val uri: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateVhdDistributorArgs> {
    override fun toJava():
        com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateVhdDistributorArgs =
        com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateVhdDistributorArgs.builder()
            .artifactTags(
                artifactTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .runOutputName(runOutputName.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .uri(uri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageTemplateVhdDistributorArgs].
 */
@PulumiTagMarker
public class ImageTemplateVhdDistributorArgsBuilder internal constructor() {
    private var artifactTags: Output<Map<String, String>>? = null

    private var runOutputName: Output<String>? = null

    private var type: Output<String>? = null

    private var uri: Output<String>? = null

    /**
     * @param value Tags that will be applied to the artifact once it has been created/updated by the distributor.
     */
    @JvmName("bdkjbrjxidvkvoai")
    public suspend fun artifactTags(`value`: Output<Map<String, String>>) {
        this.artifactTags = value
    }

    /**
     * @param value The name to be used for the associated RunOutput.
     */
    @JvmName("riasveypjcfhtytr")
    public suspend fun runOutputName(`value`: Output<String>) {
        this.runOutputName = value
    }

    /**
     * @param value Type of distribution.
     * Expected value is 'VHD'.
     */
    @JvmName("lhujnuehqwgjfueu")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Optional Azure Storage URI for the distributed VHD blob. Omit to use the default (empty string) in which case VHD would be published to the storage account in the staging resource group.
     */
    @JvmName("upxvmjwojbbldhea")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value Tags that will be applied to the artifact once it has been created/updated by the distributor.
     */
    @JvmName("aypwayhhpeptkkpr")
    public suspend fun artifactTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifactTags = mapped
    }

    /**
     * @param values Tags that will be applied to the artifact once it has been created/updated by the distributor.
     */
    @JvmName("qghlpngshsvanbva")
    public fun artifactTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.artifactTags = mapped
    }

    /**
     * @param value The name to be used for the associated RunOutput.
     */
    @JvmName("fyjidprwmbvkvgin")
    public suspend fun runOutputName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.runOutputName = mapped
    }

    /**
     * @param value Type of distribution.
     * Expected value is 'VHD'.
     */
    @JvmName("rkjwwpsnbtsvmkpn")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Optional Azure Storage URI for the distributed VHD blob. Omit to use the default (empty string) in which case VHD would be published to the storage account in the staging resource group.
     */
    @JvmName("noekgifspympiktw")
    public suspend fun uri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    internal fun build(): ImageTemplateVhdDistributorArgs = ImageTemplateVhdDistributorArgs(
        artifactTags = artifactTags,
        runOutputName = runOutputName ?: throw PulumiNullFieldException("runOutputName"),
        type = type ?: throw PulumiNullFieldException("type"),
        uri = uri,
    )
}
