@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.inputs

import com.pulumi.azurenative.virtualmachineimages.inputs.PlatformImagePurchasePlanArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Purchase plan configuration for platform image.
 * @property planName Name of the purchase plan.
 * @property planProduct Product of the purchase plan.
 * @property planPublisher Publisher of the purchase plan.
 */
public data class PlatformImagePurchasePlanArgs(
    public val planName: Output<String>,
    public val planProduct: Output<String>,
    public val planPublisher: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.virtualmachineimages.inputs.PlatformImagePurchasePlanArgs> {
    override fun toJava():
        com.pulumi.azurenative.virtualmachineimages.inputs.PlatformImagePurchasePlanArgs =
        com.pulumi.azurenative.virtualmachineimages.inputs.PlatformImagePurchasePlanArgs.builder()
            .planName(planName.applyValue({ args0 -> args0 }))
            .planProduct(planProduct.applyValue({ args0 -> args0 }))
            .planPublisher(planPublisher.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PlatformImagePurchasePlanArgs].
 */
@PulumiTagMarker
public class PlatformImagePurchasePlanArgsBuilder internal constructor() {
    private var planName: Output<String>? = null

    private var planProduct: Output<String>? = null

    private var planPublisher: Output<String>? = null

    /**
     * @param value Name of the purchase plan.
     */
    @JvmName("uofpyafsxhaesltu")
    public suspend fun planName(`value`: Output<String>) {
        this.planName = value
    }

    /**
     * @param value Product of the purchase plan.
     */
    @JvmName("yiekqojoyeuqwaam")
    public suspend fun planProduct(`value`: Output<String>) {
        this.planProduct = value
    }

    /**
     * @param value Publisher of the purchase plan.
     */
    @JvmName("ptjkogvenigobxye")
    public suspend fun planPublisher(`value`: Output<String>) {
        this.planPublisher = value
    }

    /**
     * @param value Name of the purchase plan.
     */
    @JvmName("rgtqnuyakqpiujuj")
    public suspend fun planName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.planName = mapped
    }

    /**
     * @param value Product of the purchase plan.
     */
    @JvmName("fnhuawturrewdrro")
    public suspend fun planProduct(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.planProduct = mapped
    }

    /**
     * @param value Publisher of the purchase plan.
     */
    @JvmName("nyefrpcpssfotxdx")
    public suspend fun planPublisher(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.planPublisher = mapped
    }

    internal fun build(): PlatformImagePurchasePlanArgs = PlatformImagePurchasePlanArgs(
        planName = planName ?: throw PulumiNullFieldException("planName"),
        planProduct = planProduct ?: throw PulumiNullFieldException("planProduct"),
        planPublisher = planPublisher ?: throw PulumiNullFieldException("planPublisher"),
    )
}
