@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Represents a trigger that can invoke an image template build.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property kind The kind of trigger.
 * @property name The name of the resource
 * @property provisioningState Provisioning state of the resource
 * @property status Trigger status
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetTriggerResult(
    public val id: String,
    public val kind: String,
    public val name: String,
    public val provisioningState: String,
    public val status: TriggerStatusResponse,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.virtualmachineimages.outputs.GetTriggerResult):
            GetTriggerResult = GetTriggerResult(
            id = javaType.id(),
            kind = javaType.kind(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            status = javaType.status().let({ args0 ->
                com.pulumi.azurenative.virtualmachineimages.kotlin.outputs.TriggerStatusResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.virtualmachineimages.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
