@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.outputs

import kotlin.Suppress

/**
 * Specifies optimization to be performed on image.
 * @property vmBoot Optimization is applied on the image for a faster VM boot.
 */
public data class ImageTemplatePropertiesResponseOptimize(
    public val vmBoot: ImageTemplatePropertiesResponseVmBoot? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.virtualmachineimages.outputs.ImageTemplatePropertiesResponseOptimize):
            ImageTemplatePropertiesResponseOptimize = ImageTemplatePropertiesResponseOptimize(
            vmBoot = javaType.vmBoot().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.virtualmachineimages.kotlin.outputs.ImageTemplatePropertiesResponseVmBoot.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
