@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.visualstudio.kotlin.inputs

import com.pulumi.azurenative.visualstudio.inputs.ExtensionResourcePlanArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Plan data for an extension resource.
 * @property name Name of the plan.
 * @property product Product name.
 * @property promotionCode Optional: the promotion code associated with the plan.
 * @property publisher Name of the extension publisher.
 * @property version A string that uniquely identifies the plan version.
 */
public data class ExtensionResourcePlanArgs(
    public val name: Output<String>? = null,
    public val product: Output<String>? = null,
    public val promotionCode: Output<String>? = null,
    public val publisher: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.visualstudio.inputs.ExtensionResourcePlanArgs> {
    override fun toJava(): com.pulumi.azurenative.visualstudio.inputs.ExtensionResourcePlanArgs =
        com.pulumi.azurenative.visualstudio.inputs.ExtensionResourcePlanArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .product(product?.applyValue({ args0 -> args0 }))
            .promotionCode(promotionCode?.applyValue({ args0 -> args0 }))
            .publisher(publisher?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExtensionResourcePlanArgs].
 */
@PulumiTagMarker
public class ExtensionResourcePlanArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var product: Output<String>? = null

    private var promotionCode: Output<String>? = null

    private var publisher: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value Name of the plan.
     */
    @JvmName("hkanhxdikycdqtdi")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Product name.
     */
    @JvmName("fuygithnwmyecksc")
    public suspend fun product(`value`: Output<String>) {
        this.product = value
    }

    /**
     * @param value Optional: the promotion code associated with the plan.
     */
    @JvmName("dfykvolynkivolbc")
    public suspend fun promotionCode(`value`: Output<String>) {
        this.promotionCode = value
    }

    /**
     * @param value Name of the extension publisher.
     */
    @JvmName("jqwxtrwwkxdqxdwg")
    public suspend fun publisher(`value`: Output<String>) {
        this.publisher = value
    }

    /**
     * @param value A string that uniquely identifies the plan version.
     */
    @JvmName("vfefiwyvgpvakexr")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Name of the plan.
     */
    @JvmName("rgftefxktnjgtxma")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Product name.
     */
    @JvmName("afmjqqksjlxomvki")
    public suspend fun product(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.product = mapped
    }

    /**
     * @param value Optional: the promotion code associated with the plan.
     */
    @JvmName("nqqrwweutsbscbtp")
    public suspend fun promotionCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.promotionCode = mapped
    }

    /**
     * @param value Name of the extension publisher.
     */
    @JvmName("xuhqcafnnhdevqey")
    public suspend fun publisher(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publisher = mapped
    }

    /**
     * @param value A string that uniquely identifies the plan version.
     */
    @JvmName("uetapolaneuewelm")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): ExtensionResourcePlanArgs = ExtensionResourcePlanArgs(
        name = name,
        product = product,
        promotionCode = promotionCode,
        publisher = publisher,
        version = version,
    )
}
