@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.vmwarecloudsimple.kotlin

import com.pulumi.azurenative.vmwarecloudsimple.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.vmwarecloudsimple.kotlin.outputs.SkuResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [DedicatedCloudNode].
 */
@PulumiTagMarker
public class DedicatedCloudNodeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DedicatedCloudNodeArgs = DedicatedCloudNodeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DedicatedCloudNodeArgsBuilder.() -> Unit) {
        val builder = DedicatedCloudNodeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DedicatedCloudNode {
        val builtJavaResource =
            com.pulumi.azurenative.vmwarecloudsimple.DedicatedCloudNode(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DedicatedCloudNode(builtJavaResource)
    }
}

/**
 * Dedicated cloud node model
 * Azure REST API version: 2019-04-01. Prior API version in Azure Native 1.x: 2019-04-01.
 * ## Example Usage
 * ### CreateDedicatedCloudNode
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dedicatedCloudNode = new AzureNative.VMwareCloudSimple.DedicatedCloudNode("dedicatedCloudNode", new()
 *     {
 *         AvailabilityZoneId = "az1",
 *         DedicatedCloudNodeName = "myNode",
 *         Id = "general",
 *         Location = "westus",
 *         Name = "CS28-Node",
 *         NodesCount = 1,
 *         PlacementGroupId = "n1",
 *         PurchaseId = "56acbd46-3d36-4bbf-9b08-57c30fdf6932",
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.VMwareCloudSimple.Inputs.SkuArgs
 *         {
 *             Name = "VMware_CloudSimple_CS28",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/vmwarecloudsimple/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := vmwarecloudsimple.NewDedicatedCloudNode(ctx, "dedicatedCloudNode", &vmwarecloudsimple.DedicatedCloudNodeArgs{
 * 			AvailabilityZoneId:     pulumi.String("az1"),
 * 			DedicatedCloudNodeName: pulumi.String("myNode"),
 * 			Id:                     pulumi.String("general"),
 * 			Location:               pulumi.String("westus"),
 * 			Name:                   pulumi.String("CS28-Node"),
 * 			NodesCount:             pulumi.Int(1),
 * 			PlacementGroupId:       pulumi.String("n1"),
 * 			PurchaseId:             pulumi.String("56acbd46-3d36-4bbf-9b08-57c30fdf6932"),
 * 			ResourceGroupName:      pulumi.String("myResourceGroup"),
 * 			Sku: &vmwarecloudsimple.SkuArgs{
 * 				Name: pulumi.String("VMware_CloudSimple_CS28"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.vmwarecloudsimple.DedicatedCloudNode;
 * import com.pulumi.azurenative.vmwarecloudsimple.DedicatedCloudNodeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dedicatedCloudNode = new DedicatedCloudNode("dedicatedCloudNode", DedicatedCloudNodeArgs.builder()
 *             .availabilityZoneId("az1")
 *             .dedicatedCloudNodeName("myNode")
 *             .id("general")
 *             .location("westus")
 *             .name("CS28-Node")
 *             .nodesCount(1)
 *             .placementGroupId("n1")
 *             .purchaseId("56acbd46-3d36-4bbf-9b08-57c30fdf6932")
 *             .resourceGroupName("myResourceGroup")
 *             .sku(Map.of("name", "VMware_CloudSimple_CS28"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:vmwarecloudsimple:DedicatedCloudNode myNode /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.VMwareCloudSimple/dedicatedCloudNodes/{dedicatedCloudNodeName}
 * ```
 */
public class DedicatedCloudNode internal constructor(
    override val javaResource: com.pulumi.azurenative.vmwarecloudsimple.DedicatedCloudNode,
) : KotlinCustomResource(javaResource, DedicatedCloudNodeMapper) {
    /**
     * Availability Zone id, e.g. "az1"
     */
    public val availabilityZoneId: Output<String>
        get() = javaResource.availabilityZoneId().applyValue({ args0 -> args0 })

    /**
     * Availability Zone name, e.g. "Availability Zone 1"
     */
    public val availabilityZoneName: Output<String>
        get() = javaResource.availabilityZoneName().applyValue({ args0 -> args0 })

    /**
     * VMWare Cloud Rack Name
     */
    public val cloudRackName: Output<String>
        get() = javaResource.cloudRackName().applyValue({ args0 -> args0 })

    /**
     * date time the resource was created
     */
    public val created: Output<String>
        get() = javaResource.created().applyValue({ args0 -> args0 })

    /**
     * Azure region
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * SKU's name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * count of nodes to create
     */
    public val nodesCount: Output<Int>
        get() = javaResource.nodesCount().applyValue({ args0 -> args0 })

    /**
     * Placement Group id, e.g. "n1"
     */
    public val placementGroupId: Output<String>
        get() = javaResource.placementGroupId().applyValue({ args0 -> args0 })

    /**
     * Placement Name, e.g. "Placement Group 1"
     */
    public val placementGroupName: Output<String>
        get() = javaResource.placementGroupName().applyValue({ args0 -> args0 })

    /**
     * Private Cloud Id
     */
    public val privateCloudId: Output<String>
        get() = javaResource.privateCloudId().applyValue({ args0 -> args0 })

    /**
     * Resource Pool Name
     */
    public val privateCloudName: Output<String>
        get() = javaResource.privateCloudName().applyValue({ args0 -> args0 })

    /**
     * The provisioning status of the resource
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * purchase id
     */
    public val purchaseId: Output<String>
        get() = javaResource.purchaseId().applyValue({ args0 -> args0 })

    /**
     * Dedicated Cloud Nodes SKU
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Node status, indicates is private cloud set up on this node or not
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Dedicated Cloud Nodes tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * {resourceProviderNamespace}/{resourceType}
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * VMWare Cluster Name
     */
    public val vmwareClusterName: Output<String>
        get() = javaResource.vmwareClusterName().applyValue({ args0 -> args0 })
}

public object DedicatedCloudNodeMapper : ResourceMapper<DedicatedCloudNode> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.vmwarecloudsimple.DedicatedCloudNode::class == javaResource::class

    override fun map(javaResource: Resource): DedicatedCloudNode = DedicatedCloudNode(
        javaResource as
            com.pulumi.azurenative.vmwarecloudsimple.DedicatedCloudNode,
    )
}

/**
 * @see [DedicatedCloudNode].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DedicatedCloudNode].
 */
public suspend fun dedicatedCloudNode(
    name: String,
    block: suspend DedicatedCloudNodeResourceBuilder.() -> Unit,
): DedicatedCloudNode {
    val builder = DedicatedCloudNodeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DedicatedCloudNode].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dedicatedCloudNode(name: String): DedicatedCloudNode {
    val builder = DedicatedCloudNodeResourceBuilder()
    builder.name(name)
    return builder.build()
}
