@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.vmwarecloudsimple.kotlin.inputs

import com.pulumi.azurenative.vmwarecloudsimple.inputs.GuestOSNICCustomizationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Guest OS nic customization
 * @property allocation IP address allocation method
 * @property dnsServers List of dns servers to use
 * @property gateway Gateway addresses assigned to nic
 * @property ipAddress Static ip address for nic
 * @property mask Network mask for nic
 * @property primaryWinsServer primary WINS server for Windows
 * @property secondaryWinsServer secondary WINS server for Windows
 */
public data class GuestOSNICCustomizationArgs(
    public val allocation: Output<String>? = null,
    public val dnsServers: Output<List<String>>? = null,
    public val gateway: Output<List<String>>? = null,
    public val ipAddress: Output<String>? = null,
    public val mask: Output<String>? = null,
    public val primaryWinsServer: Output<String>? = null,
    public val secondaryWinsServer: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.vmwarecloudsimple.inputs.GuestOSNICCustomizationArgs> {
    override fun toJava(): com.pulumi.azurenative.vmwarecloudsimple.inputs.GuestOSNICCustomizationArgs =
        com.pulumi.azurenative.vmwarecloudsimple.inputs.GuestOSNICCustomizationArgs.builder()
            .allocation(allocation?.applyValue({ args0 -> args0 }))
            .dnsServers(dnsServers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .gateway(gateway?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ipAddress(ipAddress?.applyValue({ args0 -> args0 }))
            .mask(mask?.applyValue({ args0 -> args0 }))
            .primaryWinsServer(primaryWinsServer?.applyValue({ args0 -> args0 }))
            .secondaryWinsServer(secondaryWinsServer?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GuestOSNICCustomizationArgs].
 */
@PulumiTagMarker
public class GuestOSNICCustomizationArgsBuilder internal constructor() {
    private var allocation: Output<String>? = null

    private var dnsServers: Output<List<String>>? = null

    private var gateway: Output<List<String>>? = null

    private var ipAddress: Output<String>? = null

    private var mask: Output<String>? = null

    private var primaryWinsServer: Output<String>? = null

    private var secondaryWinsServer: Output<String>? = null

    /**
     * @param value IP address allocation method
     */
    @JvmName("jxbbujkqqrnioxrh")
    public suspend fun allocation(`value`: Output<String>) {
        this.allocation = value
    }

    /**
     * @param value List of dns servers to use
     */
    @JvmName("xwuygxtctcacydfw")
    public suspend fun dnsServers(`value`: Output<List<String>>) {
        this.dnsServers = value
    }

    @JvmName("glxrdqwkspnpnptx")
    public suspend fun dnsServers(vararg values: Output<String>) {
        this.dnsServers = Output.all(values.asList())
    }

    /**
     * @param values List of dns servers to use
     */
    @JvmName("riwpvfvjeygkxfgc")
    public suspend fun dnsServers(values: List<Output<String>>) {
        this.dnsServers = Output.all(values)
    }

    /**
     * @param value Gateway addresses assigned to nic
     */
    @JvmName("lqpofmhicmoffdqv")
    public suspend fun gateway(`value`: Output<List<String>>) {
        this.gateway = value
    }

    @JvmName("mtpmiencvjdhokvv")
    public suspend fun gateway(vararg values: Output<String>) {
        this.gateway = Output.all(values.asList())
    }

    /**
     * @param values Gateway addresses assigned to nic
     */
    @JvmName("pdqulbshfnklrgeg")
    public suspend fun gateway(values: List<Output<String>>) {
        this.gateway = Output.all(values)
    }

    /**
     * @param value Static ip address for nic
     */
    @JvmName("myyucmcjmlbtppaq")
    public suspend fun ipAddress(`value`: Output<String>) {
        this.ipAddress = value
    }

    /**
     * @param value Network mask for nic
     */
    @JvmName("xoghwnvgmrvxrhvn")
    public suspend fun mask(`value`: Output<String>) {
        this.mask = value
    }

    /**
     * @param value primary WINS server for Windows
     */
    @JvmName("xcqasxccfxgpflku")
    public suspend fun primaryWinsServer(`value`: Output<String>) {
        this.primaryWinsServer = value
    }

    /**
     * @param value secondary WINS server for Windows
     */
    @JvmName("rqrmwyplovrhxxnd")
    public suspend fun secondaryWinsServer(`value`: Output<String>) {
        this.secondaryWinsServer = value
    }

    /**
     * @param value IP address allocation method
     */
    @JvmName("ydtesxfcyeswrlen")
    public suspend fun allocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allocation = mapped
    }

    /**
     * @param value List of dns servers to use
     */
    @JvmName("ukxfljxkpwmrqacb")
    public suspend fun dnsServers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsServers = mapped
    }

    /**
     * @param values List of dns servers to use
     */
    @JvmName("wttiwpegwnmhaxwj")
    public suspend fun dnsServers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dnsServers = mapped
    }

    /**
     * @param value Gateway addresses assigned to nic
     */
    @JvmName("phykhqvqeejqbvks")
    public suspend fun gateway(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gateway = mapped
    }

    /**
     * @param values Gateway addresses assigned to nic
     */
    @JvmName("mxuaanksaiedgruu")
    public suspend fun gateway(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.gateway = mapped
    }

    /**
     * @param value Static ip address for nic
     */
    @JvmName("gsshdpwfkobdkmeo")
    public suspend fun ipAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddress = mapped
    }

    /**
     * @param value Network mask for nic
     */
    @JvmName("pvltqwjexccbrdpv")
    public suspend fun mask(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mask = mapped
    }

    /**
     * @param value primary WINS server for Windows
     */
    @JvmName("hcuprpdvdbqmbdpb")
    public suspend fun primaryWinsServer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryWinsServer = mapped
    }

    /**
     * @param value secondary WINS server for Windows
     */
    @JvmName("icxbhyknkmmtvmla")
    public suspend fun secondaryWinsServer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryWinsServer = mapped
    }

    internal fun build(): GuestOSNICCustomizationArgs = GuestOSNICCustomizationArgs(
        allocation = allocation,
        dnsServers = dnsServers,
        gateway = gateway,
        ipAddress = ipAddress,
        mask = mask,
        primaryWinsServer = primaryWinsServer,
        secondaryWinsServer = secondaryWinsServer,
    )
}
