@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.vmwarecloudsimple.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Virtual network model
 * @property assignable can be used in vm creation/deletion
 * @property id virtual network id (privateCloudId:vsphereId)
 * @property location Azure region
 * @property name {VirtualNetworkName}
 * @property privateCloudId The Private Cloud id
 * @property type {resourceProviderNamespace}/{resourceType}
 */
public data class VirtualNetworkResponse(
    public val assignable: Boolean,
    public val id: String,
    public val location: String,
    public val name: String,
    public val privateCloudId: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.vmwarecloudsimple.outputs.VirtualNetworkResponse):
            VirtualNetworkResponse = VirtualNetworkResponse(
            assignable = javaType.assignable(),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            privateCloudId = javaType.privateCloudId(),
            type = javaType.type(),
        )
    }
}
