@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.voiceservices.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A CommunicationsGateway resource
 * @property apiBridge Details of API bridge functionality, if required
 * @property autoGeneratedDomainNameLabel The autogenerated label used as part of the FQDNs for accessing the Communications Gateway
 * @property autoGeneratedDomainNameLabelScope The scope at which the auto-generated domain name can be re-used
 * @property codecs Voice codecs to support
 * @property connectivity How to connect back to the operator network, e.g. MAPS
 * @property e911Type How to handle 911 calls
 * @property emergencyDialStrings A list of dial strings used for emergency calling.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity The managed service identities assigned to this resource.
 * @property integratedMcpEnabled Whether an integrated Mobile Control Point is in use.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property onPremMcpEnabled Whether an on-premises Mobile Control Point is in use.
 * @property platforms What platforms to support
 * @property provisioningState Resource provisioning state.
 * @property serviceLocations The regions in which to deploy the resources needed for Teams Calling
 * @property status The current status of the deployment.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property teamsVoicemailPilotNumber This number is used in Teams Phone Mobile scenarios for access to the voicemail IVR from the native dialer.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetCommunicationsGatewayResult(
    public val apiBridge: Any? = null,
    public val autoGeneratedDomainNameLabel: String,
    public val autoGeneratedDomainNameLabelScope: String? = null,
    public val codecs: List<String>,
    public val connectivity: String,
    public val e911Type: String,
    public val emergencyDialStrings: List<String>? = null,
    public val id: String,
    public val identity: ManagedServiceIdentityResponse? = null,
    public val integratedMcpEnabled: Boolean? = null,
    public val location: String,
    public val name: String,
    public val onPremMcpEnabled: Boolean? = null,
    public val platforms: List<String>,
    public val provisioningState: String,
    public val serviceLocations: List<ServiceRegionPropertiesResponse>,
    public val status: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val teamsVoicemailPilotNumber: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.voiceservices.outputs.GetCommunicationsGatewayResult):
            GetCommunicationsGatewayResult = GetCommunicationsGatewayResult(
            apiBridge = javaType.apiBridge().map({ args0 -> args0 }).orElse(null),
            autoGeneratedDomainNameLabel = javaType.autoGeneratedDomainNameLabel(),
            autoGeneratedDomainNameLabelScope = javaType.autoGeneratedDomainNameLabelScope().map({ args0 ->
                args0
            }).orElse(null),
            codecs = javaType.codecs().map({ args0 -> args0 }),
            connectivity = javaType.connectivity(),
            e911Type = javaType.e911Type(),
            emergencyDialStrings = javaType.emergencyDialStrings().map({ args0 -> args0 }),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.voiceservices.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            integratedMcpEnabled = javaType.integratedMcpEnabled().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            onPremMcpEnabled = javaType.onPremMcpEnabled().map({ args0 -> args0 }).orElse(null),
            platforms = javaType.platforms().map({ args0 -> args0 }),
            provisioningState = javaType.provisioningState(),
            serviceLocations = javaType.serviceLocations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.voiceservices.kotlin.outputs.ServiceRegionPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.voiceservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            teamsVoicemailPilotNumber = javaType.teamsVoicemailPilotNumber().map({ args0 ->
                args0
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
