@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AppServiceEnvironmentAseCustomDnsSuffixConfiguration].
 */
@PulumiTagMarker
public class AppServiceEnvironmentAseCustomDnsSuffixConfigurationResourceBuilder internal
constructor() {
    public var name: String? = null

    public var args: AppServiceEnvironmentAseCustomDnsSuffixConfigurationArgs =
        AppServiceEnvironmentAseCustomDnsSuffixConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend AppServiceEnvironmentAseCustomDnsSuffixConfigurationArgsBuilder.() -> Unit) {
        val builder = AppServiceEnvironmentAseCustomDnsSuffixConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AppServiceEnvironmentAseCustomDnsSuffixConfiguration {
        val builtJavaResource =
            com.pulumi.azurenative.web.AppServiceEnvironmentAseCustomDnsSuffixConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )

        return AppServiceEnvironmentAseCustomDnsSuffixConfiguration(builtJavaResource)
    }
}

/**
 * Full view of the custom domain suffix configuration for ASEv3.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2022-03-01.
 * Other available API versions: 2023-01-01.
 * ## Example Usage
 * ### Update ASE custom DNS suffix configuration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var appServiceEnvironmentAseCustomDnsSuffixConfiguration = new AzureNative.Web.AppServiceEnvironmentAseCustomDnsSuffixConfiguration("appServiceEnvironmentAseCustomDnsSuffixConfiguration", new()
 *     {
 *         CertificateUrl = "https://test-kv.vault.azure.net/secrets/contosocert",
 *         DnsSuffix = "contoso.com",
 *         KeyVaultReferenceIdentity = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/test-rg/providers/microsoft.managedidentity/userassignedidentities/test-user-mi",
 *         Name = "test-ase",
 *         ResourceGroupName = "test-rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/web/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := web.NewAppServiceEnvironmentAseCustomDnsSuffixConfiguration(ctx, "appServiceEnvironmentAseCustomDnsSuffixConfiguration", &web.AppServiceEnvironmentAseCustomDnsSuffixConfigurationArgs{
 * 			CertificateUrl:            pulumi.String("https://test-kv.vault.azure.net/secrets/contosocert"),
 * 			DnsSuffix:                 pulumi.String("contoso.com"),
 * 			KeyVaultReferenceIdentity: pulumi.String("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/test-rg/providers/microsoft.managedidentity/userassignedidentities/test-user-mi"),
 * 			Name:                      pulumi.String("test-ase"),
 * 			ResourceGroupName:         pulumi.String("test-rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.web.AppServiceEnvironmentAseCustomDnsSuffixConfiguration;
 * import com.pulumi.azurenative.web.AppServiceEnvironmentAseCustomDnsSuffixConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var appServiceEnvironmentAseCustomDnsSuffixConfiguration = new AppServiceEnvironmentAseCustomDnsSuffixConfiguration("appServiceEnvironmentAseCustomDnsSuffixConfiguration", AppServiceEnvironmentAseCustomDnsSuffixConfigurationArgs.builder()
 *             .certificateUrl("https://test-kv.vault.azure.net/secrets/contosocert")
 *             .dnsSuffix("contoso.com")
 *             .keyVaultReferenceIdentity("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/test-rg/providers/microsoft.managedidentity/userassignedidentities/test-user-mi")
 *             .name("test-ase")
 *             .resourceGroupName("test-rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:AppServiceEnvironmentAseCustomDnsSuffixConfiguration customDnsSuffix /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/configurations/customdnssuffix
 * ```
 */
public class AppServiceEnvironmentAseCustomDnsSuffixConfiguration internal constructor(
    override val javaResource:
    com.pulumi.azurenative.web.AppServiceEnvironmentAseCustomDnsSuffixConfiguration,
) : KotlinCustomResource(javaResource, AppServiceEnvironmentAseCustomDnsSuffixConfigurationMapper) {
    /**
     * The URL referencing the Azure Key Vault certificate secret that should be used as the default SSL/TLS certificate for sites with the custom domain suffix.
     */
    public val certificateUrl: Output<String>?
        get() = javaResource.certificateUrl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The default custom domain suffix to use for all sites deployed on the ASE.
     */
    public val dnsSuffix: Output<String>?
        get() = javaResource.dnsSuffix().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The user-assigned identity to use for resolving the key vault certificate reference. If not specified, the system-assigned ASE identity will be used if available.
     */
    public val keyVaultReferenceIdentity: Output<String>?
        get() = javaResource.keyVaultReferenceIdentity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Kind of resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val provisioningDetails: Output<String>
        get() = javaResource.provisioningDetails().applyValue({ args0 -> args0 })

    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AppServiceEnvironmentAseCustomDnsSuffixConfigurationMapper :
    ResourceMapper<AppServiceEnvironmentAseCustomDnsSuffixConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.web.AppServiceEnvironmentAseCustomDnsSuffixConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): AppServiceEnvironmentAseCustomDnsSuffixConfiguration =
        AppServiceEnvironmentAseCustomDnsSuffixConfiguration(
            javaResource as
                com.pulumi.azurenative.web.AppServiceEnvironmentAseCustomDnsSuffixConfiguration,
        )
}

/**
 * @see [AppServiceEnvironmentAseCustomDnsSuffixConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AppServiceEnvironmentAseCustomDnsSuffixConfiguration].
 */
public suspend fun appServiceEnvironmentAseCustomDnsSuffixConfiguration(
    name: String,
    block: suspend AppServiceEnvironmentAseCustomDnsSuffixConfigurationResourceBuilder.() -> Unit,
):
    AppServiceEnvironmentAseCustomDnsSuffixConfiguration {
    val builder = AppServiceEnvironmentAseCustomDnsSuffixConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AppServiceEnvironmentAseCustomDnsSuffixConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun appServiceEnvironmentAseCustomDnsSuffixConfiguration(name: String):
    AppServiceEnvironmentAseCustomDnsSuffixConfiguration {
    val builder = AppServiceEnvironmentAseCustomDnsSuffixConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
