@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.AppServicePlanRouteForVnetArgs.builder
import com.pulumi.azurenative.web.kotlin.enums.RouteType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Virtual Network route contract used to pass routing information for a Virtual Network.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2016-09-01, 2020-10-01, 2023-01-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:AppServicePlanRouteForVnet myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes/{routeName}
 * ```
 * @property endAddress The ending address for this route. If the start address is specified in CIDR notation, this must be omitted.
 * @property kind Kind of resource.
 * @property name Name of the App Service plan.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property routeName Name of the Virtual Network route.
 * @property routeType The type of route this is:
 * DEFAULT - By default, every app has routes to the local address ranges specified by RFC1918
 * INHERITED - Routes inherited from the real Virtual Network routes
 * STATIC - Static route set on the app only
 * These values will be used for syncing an app's routes with those from a Virtual Network.
 * @property startAddress The starting address for this route. This may also include a CIDR notation, in which case the end address must not be specified.
 * @property vnetName Name of the Virtual Network.
 */
public data class AppServicePlanRouteForVnetArgs(
    public val endAddress: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val routeName: Output<String>? = null,
    public val routeType: Output<Either<String, RouteType>>? = null,
    public val startAddress: Output<String>? = null,
    public val vnetName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.AppServicePlanRouteForVnetArgs> {
    override fun toJava(): com.pulumi.azurenative.web.AppServicePlanRouteForVnetArgs =
        com.pulumi.azurenative.web.AppServicePlanRouteForVnetArgs.builder()
            .endAddress(endAddress?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .routeName(routeName?.applyValue({ args0 -> args0 }))
            .routeType(
                routeType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .startAddress(startAddress?.applyValue({ args0 -> args0 }))
            .vnetName(vnetName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AppServicePlanRouteForVnetArgs].
 */
@PulumiTagMarker
public class AppServicePlanRouteForVnetArgsBuilder internal constructor() {
    private var endAddress: Output<String>? = null

    private var kind: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var routeName: Output<String>? = null

    private var routeType: Output<Either<String, RouteType>>? = null

    private var startAddress: Output<String>? = null

    private var vnetName: Output<String>? = null

    /**
     * @param value The ending address for this route. If the start address is specified in CIDR notation, this must be omitted.
     */
    @JvmName("ugilgtyywpugivwy")
    public suspend fun endAddress(`value`: Output<String>) {
        this.endAddress = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("jvrbrhhsdusauycs")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Name of the App Service plan.
     */
    @JvmName("wtgqwcnhidkutuum")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("liptlqnwjglunvuk")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the Virtual Network route.
     */
    @JvmName("gwfhpixwrgyqqdaq")
    public suspend fun routeName(`value`: Output<String>) {
        this.routeName = value
    }

    /**
     * @param value The type of route this is:
     * DEFAULT - By default, every app has routes to the local address ranges specified by RFC1918
     * INHERITED - Routes inherited from the real Virtual Network routes
     * STATIC - Static route set on the app only
     * These values will be used for syncing an app's routes with those from a Virtual Network.
     */
    @JvmName("pnauodggfbmuceme")
    public suspend fun routeType(`value`: Output<Either<String, RouteType>>) {
        this.routeType = value
    }

    /**
     * @param value The starting address for this route. This may also include a CIDR notation, in which case the end address must not be specified.
     */
    @JvmName("vjkwdvphyvpaxyil")
    public suspend fun startAddress(`value`: Output<String>) {
        this.startAddress = value
    }

    /**
     * @param value Name of the Virtual Network.
     */
    @JvmName("knswgpsrbvubkugp")
    public suspend fun vnetName(`value`: Output<String>) {
        this.vnetName = value
    }

    /**
     * @param value The ending address for this route. If the start address is specified in CIDR notation, this must be omitted.
     */
    @JvmName("mtcfrxxnyrsngaht")
    public suspend fun endAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endAddress = mapped
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("emehlnqrtebowopb")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Name of the App Service plan.
     */
    @JvmName("ebtgtxsuhcyprnps")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("esrlfxojqvmjatpn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the Virtual Network route.
     */
    @JvmName("leonxsectwmdetxt")
    public suspend fun routeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeName = mapped
    }

    /**
     * @param value The type of route this is:
     * DEFAULT - By default, every app has routes to the local address ranges specified by RFC1918
     * INHERITED - Routes inherited from the real Virtual Network routes
     * STATIC - Static route set on the app only
     * These values will be used for syncing an app's routes with those from a Virtual Network.
     */
    @JvmName("nrrblhkpilwdjpqb")
    public suspend fun routeType(`value`: Either<String, RouteType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeType = mapped
    }

    /**
     * @param value The type of route this is:
     * DEFAULT - By default, every app has routes to the local address ranges specified by RFC1918
     * INHERITED - Routes inherited from the real Virtual Network routes
     * STATIC - Static route set on the app only
     * These values will be used for syncing an app's routes with those from a Virtual Network.
     */
    @JvmName("rotignrhjdjyeqcy")
    public fun routeType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RouteType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routeType = mapped
    }

    /**
     * @param value The type of route this is:
     * DEFAULT - By default, every app has routes to the local address ranges specified by RFC1918
     * INHERITED - Routes inherited from the real Virtual Network routes
     * STATIC - Static route set on the app only
     * These values will be used for syncing an app's routes with those from a Virtual Network.
     */
    @JvmName("mhfpwmuyjftueyhh")
    public fun routeType(`value`: RouteType) {
        val toBeMapped = Either.ofRight<String, RouteType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routeType = mapped
    }

    /**
     * @param value The starting address for this route. This may also include a CIDR notation, in which case the end address must not be specified.
     */
    @JvmName("tniohcueletvklcy")
    public suspend fun startAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startAddress = mapped
    }

    /**
     * @param value Name of the Virtual Network.
     */
    @JvmName("mosvouburegvnfqu")
    public suspend fun vnetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vnetName = mapped
    }

    internal fun build(): AppServicePlanRouteForVnetArgs = AppServicePlanRouteForVnetArgs(
        endAddress = endAddress,
        kind = kind,
        name = name,
        resourceGroupName = resourceGroupName,
        routeName = routeName,
        routeType = routeType,
        startAddress = startAddress,
        vnetName = vnetName,
    )
}
