@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.ConnectionArgs.builder
import com.pulumi.azurenative.web.kotlin.inputs.ApiConnectionDefinitionPropertiesArgs
import com.pulumi.azurenative.web.kotlin.inputs.ApiConnectionDefinitionPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * API connection
 * Azure REST API version: 2016-06-01. Prior API version in Azure Native 1.x: 2016-06-01.
 * Other available API versions: 2015-08-01-preview.
 * ## Example Usage
 * ### Replace a connection
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connection = new AzureNative.Web.Connection("connection", new()
 *     {
 *         ConnectionName = "testManagedApi",
 *         Properties = new AzureNative.Web.Inputs.ApiConnectionDefinitionPropertiesArgs
 *         {
 *             Api = new AzureNative.Web.Inputs.ApiReferenceArgs
 *             {
 *                 Id = "/subscriptions/f34b22a3-2202-4fb1-b040-1332bd928c84/providers/Microsoft.Web/locations/centralus/managedApis/testManagedApi",
 *             },
 *             CustomParameterValues = null,
 *             DisplayName = "testManagedApi",
 *             ParameterValues = null,
 *         },
 *         ResourceGroupName = "testResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/web/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := web.NewConnection(ctx, "connection", &web.ConnectionArgs{
 * 			ConnectionName: pulumi.String("testManagedApi"),
 * 			Properties: web.ApiConnectionDefinitionResponseProperties{
 * 				Api: &web.ApiReferenceArgs{
 * 					Id: pulumi.String("/subscriptions/f34b22a3-2202-4fb1-b040-1332bd928c84/providers/Microsoft.Web/locations/centralus/managedApis/testManagedApi"),
 * 				},
 * 				CustomParameterValues: nil,
 * 				DisplayName:           pulumi.String("testManagedApi"),
 * 				ParameterValues:       nil,
 * 			},
 * 			ResourceGroupName: pulumi.String("testResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.web.Connection;
 * import com.pulumi.azurenative.web.ConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connection = new Connection("connection", ConnectionArgs.builder()
 *             .connectionName("testManagedApi")
 *             .properties(Map.ofEntries(
 *                 Map.entry("api", Map.of("id", "/subscriptions/f34b22a3-2202-4fb1-b040-1332bd928c84/providers/Microsoft.Web/locations/centralus/managedApis/testManagedApi")),
 *                 Map.entry("customParameterValues", ),
 *                 Map.entry("displayName", "testManagedApi"),
 *                 Map.entry("parameterValues", )
 *             ))
 *             .resourceGroupName("testResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:Connection testManagedApi-1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/connections/{connectionName}
 * ```
 * @property connectionName Connection name
 * @property location Resource location
 * @property properties
 * @property resourceGroupName The resource group
 * @property subscriptionId Subscription Id
 * @property tags Resource tags
 */
public data class ConnectionArgs(
    public val connectionName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<ApiConnectionDefinitionPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val subscriptionId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.ConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.web.ConnectionArgs =
        com.pulumi.azurenative.web.ConnectionArgs.builder()
            .connectionName(connectionName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .subscriptionId(subscriptionId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ConnectionArgs].
 */
@PulumiTagMarker
public class ConnectionArgsBuilder internal constructor() {
    private var connectionName: Output<String>? = null

    private var location: Output<String>? = null

    private var properties: Output<ApiConnectionDefinitionPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var subscriptionId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Connection name
     */
    @JvmName("oqgohhpritsyctld")
    public suspend fun connectionName(`value`: Output<String>) {
        this.connectionName = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("rjysyyibcxyostuv")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value
     */
    @JvmName("gihohocdkmyerrri")
    public suspend fun properties(`value`: Output<ApiConnectionDefinitionPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The resource group
     */
    @JvmName("pgchjudjbdewqcft")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Subscription Id
     */
    @JvmName("itaipkibsvcrldxk")
    public suspend fun subscriptionId(`value`: Output<String>) {
        this.subscriptionId = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("evxxpxxshktdqmkp")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Connection name
     */
    @JvmName("brvtxatofvlcqyan")
    public suspend fun connectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionName = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("nyptmmaljpufxqbq")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value
     */
    @JvmName("yvlybfmsphqmnbxi")
    public suspend fun properties(`value`: ApiConnectionDefinitionPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument
     */
    @JvmName("gngsglahpqfxrqfd")
    public suspend
    fun properties(argument: suspend ApiConnectionDefinitionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ApiConnectionDefinitionPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The resource group
     */
    @JvmName("iklahivyqppeklew")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Subscription Id
     */
    @JvmName("temjyjqrobwusdwx")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionId = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("uydtfiukicqcxole")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("yhlkathbdleluutw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ConnectionArgs = ConnectionArgs(
        connectionName = connectionName,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        subscriptionId = subscriptionId,
        tags = tags,
    )
}
