@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.kotlin.outputs.ConnectionGatewayDefinitionResponseProperties
import com.pulumi.azurenative.web.kotlin.outputs.ConnectionGatewayDefinitionResponseProperties.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ConnectionGateway].
 */
@PulumiTagMarker
public class ConnectionGatewayResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConnectionGatewayArgs = ConnectionGatewayArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConnectionGatewayArgsBuilder.() -> Unit) {
        val builder = ConnectionGatewayArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ConnectionGateway {
        val builtJavaResource = com.pulumi.azurenative.web.ConnectionGateway(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ConnectionGateway(builtJavaResource)
    }
}

/**
 * The gateway definition
 * Azure REST API version: 2016-06-01. Prior API version in Azure Native 1.x: 2016-06-01.
 * ## Example Usage
 * ### Replace a connection gateway definition
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connectionGateway = new AzureNative.Web.ConnectionGateway("connectionGateway", new()
 *     {
 *         ConnectionGatewayName = "test123",
 *         Properties = new AzureNative.Web.Inputs.ConnectionGatewayDefinitionPropertiesArgs
 *         {
 *             BackendUri = "https://WABI-WEST-US-redirect.analysis.windows.net",
 *             ConnectionGatewayInstallation = new AzureNative.Web.Inputs.ConnectionGatewayReferenceArgs
 *             {
 *                 Id = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/providers/Microsoft.Web/locations/westus/connectionGatewayInstallations/865dccd1-5d5c-45fe-b5a0-249d4de4134c",
 *             },
 *             ContactInformation = new[]
 *             {
 *                 "test123@microsoft.com",
 *             },
 *             DisplayName = "test123",
 *             MachineName = "TEST123",
 *             Status = "Installed",
 *         },
 *         ResourceGroupName = "testResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/web/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := web.NewConnectionGateway(ctx, "connectionGateway", &web.ConnectionGatewayArgs{
 * 			ConnectionGatewayName: pulumi.String("test123"),
 * 			Properties: web.ConnectionGatewayDefinitionResponseProperties{
 * 				BackendUri: pulumi.String("https://WABI-WEST-US-redirect.analysis.windows.net"),
 * 				ConnectionGatewayInstallation: &web.ConnectionGatewayReferenceArgs{
 * 					Id: pulumi.String("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/providers/Microsoft.Web/locations/westus/connectionGatewayInstallations/865dccd1-5d5c-45fe-b5a0-249d4de4134c"),
 * 				},
 * 				ContactInformation: pulumi.StringArray{
 * 					pulumi.String("test123@microsoft.com"),
 * 				},
 * 				DisplayName: pulumi.String("test123"),
 * 				MachineName: pulumi.String("TEST123"),
 * 				Status:      pulumi.Any("Installed"),
 * 			},
 * 			ResourceGroupName: pulumi.String("testResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.web.ConnectionGateway;
 * import com.pulumi.azurenative.web.ConnectionGatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connectionGateway = new ConnectionGateway("connectionGateway", ConnectionGatewayArgs.builder()
 *             .connectionGatewayName("test123")
 *             .properties(Map.ofEntries(
 *                 Map.entry("backendUri", "https://WABI-WEST-US-redirect.analysis.windows.net"),
 *                 Map.entry("connectionGatewayInstallation", Map.of("id", "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/providers/Microsoft.Web/locations/westus/connectionGatewayInstallations/865dccd1-5d5c-45fe-b5a0-249d4de4134c")),
 *                 Map.entry("contactInformation", "test123@microsoft.com"),
 *                 Map.entry("displayName", "test123"),
 *                 Map.entry("machineName", "TEST123"),
 *                 Map.entry("status", "Installed")
 *             ))
 *             .resourceGroupName("testResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:ConnectionGateway test123 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/connectionGateways/{connectionGatewayName}
 * ```
 */
public class ConnectionGateway internal constructor(
    override val javaResource: com.pulumi.azurenative.web.ConnectionGateway,
) : KotlinCustomResource(javaResource, ConnectionGatewayMapper) {
    /**
     * Resource ETag
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource location
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val properties: Output<ConnectionGatewayDefinitionResponseProperties>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ConnectionGatewayMapper : ResourceMapper<ConnectionGateway> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.web.ConnectionGateway::class == javaResource::class

    override fun map(javaResource: Resource): ConnectionGateway = ConnectionGateway(
        javaResource as
            com.pulumi.azurenative.web.ConnectionGateway,
    )
}

/**
 * @see [ConnectionGateway].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConnectionGateway].
 */
public suspend fun connectionGateway(
    name: String,
    block: suspend ConnectionGatewayResourceBuilder.() -> Unit,
): ConnectionGateway {
    val builder = ConnectionGatewayResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConnectionGateway].
 * @param name The _unique_ name of the resulting resource.
 */
public fun connectionGateway(name: String): ConnectionGateway {
    val builder = ConnectionGatewayResourceBuilder()
    builder.name(name)
    return builder.build()
}
