@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.StaticSiteArgs.builder
import com.pulumi.azurenative.web.kotlin.enums.EnterpriseGradeCdnStatus
import com.pulumi.azurenative.web.kotlin.enums.StagingEnvironmentPolicy
import com.pulumi.azurenative.web.kotlin.inputs.ManagedServiceIdentityArgs
import com.pulumi.azurenative.web.kotlin.inputs.ManagedServiceIdentityArgsBuilder
import com.pulumi.azurenative.web.kotlin.inputs.SkuDescriptionArgs
import com.pulumi.azurenative.web.kotlin.inputs.SkuDescriptionArgsBuilder
import com.pulumi.azurenative.web.kotlin.inputs.StaticSiteBuildPropertiesArgs
import com.pulumi.azurenative.web.kotlin.inputs.StaticSiteBuildPropertiesArgsBuilder
import com.pulumi.azurenative.web.kotlin.inputs.StaticSiteTemplateOptionsArgs
import com.pulumi.azurenative.web.kotlin.inputs.StaticSiteTemplateOptionsArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Static Site ARM resource.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-10-01, 2021-02-01, 2023-01-01.
 * ## Example Usage
 * ### Create or update a static site
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var staticSite = new AzureNative.Web.StaticSite("staticSite", new()
 *     {
 *         Branch = "master",
 *         BuildProperties = new AzureNative.Web.Inputs.StaticSiteBuildPropertiesArgs
 *         {
 *             ApiLocation = "api",
 *             AppArtifactLocation = "build",
 *             AppLocation = "app",
 *         },
 *         Location = "West US 2",
 *         Name = "testStaticSite0",
 *         RepositoryToken = "repoToken123",
 *         RepositoryUrl = "https://github.com/username/RepoName",
 *         ResourceGroupName = "rg",
 *         Sku = new AzureNative.Web.Inputs.SkuDescriptionArgs
 *         {
 *             Name = "Basic",
 *             Tier = "Basic",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/web/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := web.NewStaticSite(ctx, "staticSite", &web.StaticSiteArgs{
 * 			Branch: pulumi.String("master"),
 * 			BuildProperties: &web.StaticSiteBuildPropertiesArgs{
 * 				ApiLocation:         pulumi.String("api"),
 * 				AppArtifactLocation: pulumi.String("build"),
 * 				AppLocation:         pulumi.String("app"),
 * 			},
 * 			Location:          pulumi.String("West US 2"),
 * 			Name:              pulumi.String("testStaticSite0"),
 * 			RepositoryToken:   pulumi.String("repoToken123"),
 * 			RepositoryUrl:     pulumi.String("https://github.com/username/RepoName"),
 * 			ResourceGroupName: pulumi.String("rg"),
 * 			Sku: &web.SkuDescriptionArgs{
 * 				Name: pulumi.String("Basic"),
 * 				Tier: pulumi.String("Basic"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.web.StaticSite;
 * import com.pulumi.azurenative.web.StaticSiteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var staticSite = new StaticSite("staticSite", StaticSiteArgs.builder()
 *             .branch("master")
 *             .buildProperties(Map.ofEntries(
 *                 Map.entry("apiLocation", "api"),
 *                 Map.entry("appArtifactLocation", "build"),
 *                 Map.entry("appLocation", "app")
 *             ))
 *             .location("West US 2")
 *             .name("testStaticSite0")
 *             .repositoryToken("repoToken123")
 *             .repositoryUrl("https://github.com/username/RepoName")
 *             .resourceGroupName("rg")
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Basic"),
 *                 Map.entry("tier", "Basic")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:StaticSite testStaticSite0 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}
 * ```
 * @property allowConfigFileUpdates <code>false</code> if config file is locked for this static web app; otherwise, <code>true</code>.
 * @property branch The target branch in the repository.
 * @property buildProperties Build properties to configure on the repository.
 * @property enterpriseGradeCdnStatus State indicating the status of the enterprise grade CDN serving traffic to the static web app.
 * @property identity Managed service identity.
 * @property kind Kind of resource.
 * @property location Resource Location.
 * @property name Name of the static site to create or update.
 * @property provider The provider that submitted the last deployment to the primary environment of the static site.
 * @property publicNetworkAccess State indicating whether public traffic are allowed or not for a static web app. Allowed Values: 'Enabled', 'Disabled' or an empty string.
 * @property repositoryToken A user's github repository token. This is used to setup the Github Actions workflow file and API secrets.
 * @property repositoryUrl URL for the repository of the static site.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property sku Description of a SKU for a scalable resource.
 * @property stagingEnvironmentPolicy State indicating whether staging environments are allowed or not allowed for a static web app.
 * @property tags Resource tags.
 * @property templateProperties Template options for generating a new repository.
 */
public data class StaticSiteArgs(
    public val allowConfigFileUpdates: Output<Boolean>? = null,
    public val branch: Output<String>? = null,
    public val buildProperties: Output<StaticSiteBuildPropertiesArgs>? = null,
    public val enterpriseGradeCdnStatus: Output<Either<String, EnterpriseGradeCdnStatus>>? = null,
    public val identity: Output<ManagedServiceIdentityArgs>? = null,
    public val kind: Output<String>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val provider: Output<String>? = null,
    public val publicNetworkAccess: Output<String>? = null,
    public val repositoryToken: Output<String>? = null,
    public val repositoryUrl: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuDescriptionArgs>? = null,
    public val stagingEnvironmentPolicy: Output<StagingEnvironmentPolicy>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val templateProperties: Output<StaticSiteTemplateOptionsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.StaticSiteArgs> {
    override fun toJava(): com.pulumi.azurenative.web.StaticSiteArgs =
        com.pulumi.azurenative.web.StaticSiteArgs.builder()
            .allowConfigFileUpdates(allowConfigFileUpdates?.applyValue({ args0 -> args0 }))
            .branch(branch?.applyValue({ args0 -> args0 }))
            .buildProperties(buildProperties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enterpriseGradeCdnStatus(
                enterpriseGradeCdnStatus?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .provider(provider?.applyValue({ args0 -> args0 }))
            .publicNetworkAccess(publicNetworkAccess?.applyValue({ args0 -> args0 }))
            .repositoryToken(repositoryToken?.applyValue({ args0 -> args0 }))
            .repositoryUrl(repositoryUrl?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .stagingEnvironmentPolicy(
                stagingEnvironmentPolicy?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .templateProperties(
                templateProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [StaticSiteArgs].
 */
@PulumiTagMarker
public class StaticSiteArgsBuilder internal constructor() {
    private var allowConfigFileUpdates: Output<Boolean>? = null

    private var branch: Output<String>? = null

    private var buildProperties: Output<StaticSiteBuildPropertiesArgs>? = null

    private var enterpriseGradeCdnStatus: Output<Either<String, EnterpriseGradeCdnStatus>>? = null

    private var identity: Output<ManagedServiceIdentityArgs>? = null

    private var kind: Output<String>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var provider: Output<String>? = null

    private var publicNetworkAccess: Output<String>? = null

    private var repositoryToken: Output<String>? = null

    private var repositoryUrl: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuDescriptionArgs>? = null

    private var stagingEnvironmentPolicy: Output<StagingEnvironmentPolicy>? = null

    private var tags: Output<Map<String, String>>? = null

    private var templateProperties: Output<StaticSiteTemplateOptionsArgs>? = null

    /**
     * @param value <code>false</code> if config file is locked for this static web app; otherwise, <code>true</code>.
     */
    @JvmName("eviviekkdiedyeom")
    public suspend fun allowConfigFileUpdates(`value`: Output<Boolean>) {
        this.allowConfigFileUpdates = value
    }

    /**
     * @param value The target branch in the repository.
     */
    @JvmName("pxhrrukivqnftaox")
    public suspend fun branch(`value`: Output<String>) {
        this.branch = value
    }

    /**
     * @param value Build properties to configure on the repository.
     */
    @JvmName("ikxijrchttyblpvp")
    public suspend fun buildProperties(`value`: Output<StaticSiteBuildPropertiesArgs>) {
        this.buildProperties = value
    }

    /**
     * @param value State indicating the status of the enterprise grade CDN serving traffic to the static web app.
     */
    @JvmName("axpyajglisdbakkq")
    public suspend
    fun enterpriseGradeCdnStatus(`value`: Output<Either<String, EnterpriseGradeCdnStatus>>) {
        this.enterpriseGradeCdnStatus = value
    }

    /**
     * @param value Managed service identity.
     */
    @JvmName("uejbpkfgtapixfcn")
    public suspend fun identity(`value`: Output<ManagedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("smudfpipvubifggc")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Resource Location.
     */
    @JvmName("ufhncrhfhobjiemi")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of the static site to create or update.
     */
    @JvmName("rpmlemekqxgnhjsl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The provider that submitted the last deployment to the primary environment of the static site.
     */
    @JvmName("mruprubvxtycehpn")
    public suspend fun provider(`value`: Output<String>) {
        this.provider = value
    }

    /**
     * @param value State indicating whether public traffic are allowed or not for a static web app. Allowed Values: 'Enabled', 'Disabled' or an empty string.
     */
    @JvmName("pvhkrubecnklhgvw")
    public suspend fun publicNetworkAccess(`value`: Output<String>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value A user's github repository token. This is used to setup the Github Actions workflow file and API secrets.
     */
    @JvmName("fnujfmfjjdadibbr")
    public suspend fun repositoryToken(`value`: Output<String>) {
        this.repositoryToken = value
    }

    /**
     * @param value URL for the repository of the static site.
     */
    @JvmName("ovjjxkugwpoxxamn")
    public suspend fun repositoryUrl(`value`: Output<String>) {
        this.repositoryUrl = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("uowotekvadmajdsd")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Description of a SKU for a scalable resource.
     */
    @JvmName("lwpewshahixpskdc")
    public suspend fun sku(`value`: Output<SkuDescriptionArgs>) {
        this.sku = value
    }

    /**
     * @param value State indicating whether staging environments are allowed or not allowed for a static web app.
     */
    @JvmName("upbqfkkaqqopehiw")
    public suspend fun stagingEnvironmentPolicy(`value`: Output<StagingEnvironmentPolicy>) {
        this.stagingEnvironmentPolicy = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("pytyesnctfhpdksv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Template options for generating a new repository.
     */
    @JvmName("jpbqkknvwqvufrit")
    public suspend fun templateProperties(`value`: Output<StaticSiteTemplateOptionsArgs>) {
        this.templateProperties = value
    }

    /**
     * @param value <code>false</code> if config file is locked for this static web app; otherwise, <code>true</code>.
     */
    @JvmName("wlqkxpksidfvhowu")
    public suspend fun allowConfigFileUpdates(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowConfigFileUpdates = mapped
    }

    /**
     * @param value The target branch in the repository.
     */
    @JvmName("lpgriajvavhtjvla")
    public suspend fun branch(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.branch = mapped
    }

    /**
     * @param value Build properties to configure on the repository.
     */
    @JvmName("enusqcinopwiqpad")
    public suspend fun buildProperties(`value`: StaticSiteBuildPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.buildProperties = mapped
    }

    /**
     * @param argument Build properties to configure on the repository.
     */
    @JvmName("wnpeqiubqmpvpmov")
    public suspend
    fun buildProperties(argument: suspend StaticSiteBuildPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = StaticSiteBuildPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.buildProperties = mapped
    }

    /**
     * @param value State indicating the status of the enterprise grade CDN serving traffic to the static web app.
     */
    @JvmName("ypwqwqpthaqgwvvk")
    public suspend fun enterpriseGradeCdnStatus(`value`: Either<String, EnterpriseGradeCdnStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enterpriseGradeCdnStatus = mapped
    }

    /**
     * @param value State indicating the status of the enterprise grade CDN serving traffic to the static web app.
     */
    @JvmName("euwhyedvtbweipvg")
    public fun enterpriseGradeCdnStatus(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EnterpriseGradeCdnStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enterpriseGradeCdnStatus = mapped
    }

    /**
     * @param value State indicating the status of the enterprise grade CDN serving traffic to the static web app.
     */
    @JvmName("ncsbmfshdddcnyhs")
    public fun enterpriseGradeCdnStatus(`value`: EnterpriseGradeCdnStatus) {
        val toBeMapped = Either.ofRight<String, EnterpriseGradeCdnStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enterpriseGradeCdnStatus = mapped
    }

    /**
     * @param value Managed service identity.
     */
    @JvmName("oiavvagpnhyiptxi")
    public suspend fun identity(`value`: ManagedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Managed service identity.
     */
    @JvmName("nrwspotgugvikfsq")
    public suspend fun identity(argument: suspend ManagedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("vrsykjhllhcdkkxk")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Resource Location.
     */
    @JvmName("opklqtoiaqytocxv")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of the static site to create or update.
     */
    @JvmName("khlthwyusieumxco")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The provider that submitted the last deployment to the primary environment of the static site.
     */
    @JvmName("gtujhegumiqblmle")
    public suspend fun provider(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provider = mapped
    }

    /**
     * @param value State indicating whether public traffic are allowed or not for a static web app. Allowed Values: 'Enabled', 'Disabled' or an empty string.
     */
    @JvmName("dfhltcmlijdgyyhm")
    public suspend fun publicNetworkAccess(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value A user's github repository token. This is used to setup the Github Actions workflow file and API secrets.
     */
    @JvmName("uedljitcdefvhanh")
    public suspend fun repositoryToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repositoryToken = mapped
    }

    /**
     * @param value URL for the repository of the static site.
     */
    @JvmName("plqigbggsgudtcxf")
    public suspend fun repositoryUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repositoryUrl = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("ufcncsbcrmrnsqrg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Description of a SKU for a scalable resource.
     */
    @JvmName("cicrwikkfjsgceus")
    public suspend fun sku(`value`: SkuDescriptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument Description of a SKU for a scalable resource.
     */
    @JvmName("uxbvekmawihitgwi")
    public suspend fun sku(argument: suspend SkuDescriptionArgsBuilder.() -> Unit) {
        val toBeMapped = SkuDescriptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value State indicating whether staging environments are allowed or not allowed for a static web app.
     */
    @JvmName("vdotteocrxvjtdqo")
    public suspend fun stagingEnvironmentPolicy(`value`: StagingEnvironmentPolicy?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stagingEnvironmentPolicy = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("hxswrndhvtcoqnik")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("ujejlrvfxxrgvpom")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Template options for generating a new repository.
     */
    @JvmName("qhopfpfduegssofu")
    public suspend fun templateProperties(`value`: StaticSiteTemplateOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateProperties = mapped
    }

    /**
     * @param argument Template options for generating a new repository.
     */
    @JvmName("hpwubicwgwbbvper")
    public suspend
    fun templateProperties(argument: suspend StaticSiteTemplateOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = StaticSiteTemplateOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.templateProperties = mapped
    }

    internal fun build(): StaticSiteArgs = StaticSiteArgs(
        allowConfigFileUpdates = allowConfigFileUpdates,
        branch = branch,
        buildProperties = buildProperties,
        enterpriseGradeCdnStatus = enterpriseGradeCdnStatus,
        identity = identity,
        kind = kind,
        location = location,
        name = name,
        provider = provider,
        publicNetworkAccess = publicNetworkAccess,
        repositoryToken = repositoryToken,
        repositoryUrl = repositoryUrl,
        resourceGroupName = resourceGroupName,
        sku = sku,
        stagingEnvironmentPolicy = stagingEnvironmentPolicy,
        tags = tags,
        templateProperties = templateProperties,
    )
}
