@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [StaticSiteLinkedBackendForBuild].
 */
@PulumiTagMarker
public class StaticSiteLinkedBackendForBuildResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StaticSiteLinkedBackendForBuildArgs = StaticSiteLinkedBackendForBuildArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StaticSiteLinkedBackendForBuildArgsBuilder.() -> Unit) {
        val builder = StaticSiteLinkedBackendForBuildArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): StaticSiteLinkedBackendForBuild {
        val builtJavaResource =
            com.pulumi.azurenative.web.StaticSiteLinkedBackendForBuild(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return StaticSiteLinkedBackendForBuild(builtJavaResource)
    }
}

/**
 * Static Site Linked Backend ARM resource.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2022-03-01.
 * Other available API versions: 2023-01-01.
 * ## Example Usage
 * ### Link a backend to a static site build
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var staticSiteLinkedBackendForBuild = new AzureNative.Web.StaticSiteLinkedBackendForBuild("staticSiteLinkedBackendForBuild", new()
 *     {
 *         BackendResourceId = "/subscription/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/backendRg/providers/Microsoft.Web/sites/testBackend",
 *         EnvironmentName = "default",
 *         LinkedBackendName = "testBackend",
 *         Name = "testStaticSite0",
 *         Region = "West US 2",
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/web/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := web.NewStaticSiteLinkedBackendForBuild(ctx, "staticSiteLinkedBackendForBuild", &web.StaticSiteLinkedBackendForBuildArgs{
 * 			BackendResourceId: pulumi.String("/subscription/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/backendRg/providers/Microsoft.Web/sites/testBackend"),
 * 			EnvironmentName:   pulumi.String("default"),
 * 			LinkedBackendName: pulumi.String("testBackend"),
 * 			Name:              pulumi.String("testStaticSite0"),
 * 			Region:            pulumi.String("West US 2"),
 * 			ResourceGroupName: pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.web.StaticSiteLinkedBackendForBuild;
 * import com.pulumi.azurenative.web.StaticSiteLinkedBackendForBuildArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var staticSiteLinkedBackendForBuild = new StaticSiteLinkedBackendForBuild("staticSiteLinkedBackendForBuild", StaticSiteLinkedBackendForBuildArgs.builder()
 *             .backendResourceId("/subscription/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/backendRg/providers/Microsoft.Web/sites/testBackend")
 *             .environmentName("default")
 *             .linkedBackendName("testBackend")
 *             .name("testStaticSite0")
 *             .region("West US 2")
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:StaticSiteLinkedBackendForBuild testBackend /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/linkedBackends/{linkedBackendName}
 * ```
 */
public class StaticSiteLinkedBackendForBuild internal constructor(
    override val javaResource: com.pulumi.azurenative.web.StaticSiteLinkedBackendForBuild,
) : KotlinCustomResource(javaResource, StaticSiteLinkedBackendForBuildMapper) {
    /**
     * The resource id of the backend linked to the static site
     */
    public val backendResourceId: Output<String>?
        get() = javaResource.backendResourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The date and time on which the backend was linked to the static site.
     */
    public val createdOn: Output<String>
        get() = javaResource.createdOn().applyValue({ args0 -> args0 })

    /**
     * Kind of resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the linking process.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The region of the backend linked to the static site
     */
    public val region: Output<String>?
        get() = javaResource.region().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object StaticSiteLinkedBackendForBuildMapper :
    ResourceMapper<StaticSiteLinkedBackendForBuild> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.web.StaticSiteLinkedBackendForBuild::class == javaResource::class

    override fun map(javaResource: Resource): StaticSiteLinkedBackendForBuild =
        StaticSiteLinkedBackendForBuild(
            javaResource as
                com.pulumi.azurenative.web.StaticSiteLinkedBackendForBuild,
        )
}

/**
 * @see [StaticSiteLinkedBackendForBuild].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StaticSiteLinkedBackendForBuild].
 */
public suspend fun staticSiteLinkedBackendForBuild(
    name: String,
    block: suspend StaticSiteLinkedBackendForBuildResourceBuilder.() -> Unit,
):
    StaticSiteLinkedBackendForBuild {
    val builder = StaticSiteLinkedBackendForBuildResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StaticSiteLinkedBackendForBuild].
 * @param name The _unique_ name of the resulting resource.
 */
public fun staticSiteLinkedBackendForBuild(name: String): StaticSiteLinkedBackendForBuild {
    val builder = StaticSiteLinkedBackendForBuildResourceBuilder()
    builder.name(name)
    return builder.build()
}
