@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [StaticSiteUserProvidedFunctionAppForStaticSite].
 */
@PulumiTagMarker
public class StaticSiteUserProvidedFunctionAppForStaticSiteResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StaticSiteUserProvidedFunctionAppForStaticSiteArgs =
        StaticSiteUserProvidedFunctionAppForStaticSiteArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend StaticSiteUserProvidedFunctionAppForStaticSiteArgsBuilder.() -> Unit) {
        val builder = StaticSiteUserProvidedFunctionAppForStaticSiteArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): StaticSiteUserProvidedFunctionAppForStaticSite {
        val builtJavaResource =
            com.pulumi.azurenative.web.StaticSiteUserProvidedFunctionAppForStaticSite(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return StaticSiteUserProvidedFunctionAppForStaticSite(builtJavaResource)
    }
}

/**
 * Static Site User Provided Function App ARM resource.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2023-01-01.
 * ## Example Usage
 * ### Register a user provided function app with a static site
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var staticSiteUserProvidedFunctionAppForStaticSite = new AzureNative.Web.StaticSiteUserProvidedFunctionAppForStaticSite("staticSiteUserProvidedFunctionAppForStaticSite", new()
 *     {
 *         FunctionAppName = "testFunctionApp",
 *         FunctionAppRegion = "West US 2",
 *         FunctionAppResourceId = "/subscription/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/functionRG/providers/Microsoft.Web/sites/testFunctionApp",
 *         IsForced = true,
 *         Name = "testStaticSite0",
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/web/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := web.NewStaticSiteUserProvidedFunctionAppForStaticSite(ctx, "staticSiteUserProvidedFunctionAppForStaticSite", &web.StaticSiteUserProvidedFunctionAppForStaticSiteArgs{
 * 			FunctionAppName:       pulumi.String("testFunctionApp"),
 * 			FunctionAppRegion:     pulumi.String("West US 2"),
 * 			FunctionAppResourceId: pulumi.String("/subscription/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/functionRG/providers/Microsoft.Web/sites/testFunctionApp"),
 * 			IsForced:              pulumi.Bool(true),
 * 			Name:                  pulumi.String("testStaticSite0"),
 * 			ResourceGroupName:     pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.web.StaticSiteUserProvidedFunctionAppForStaticSite;
 * import com.pulumi.azurenative.web.StaticSiteUserProvidedFunctionAppForStaticSiteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var staticSiteUserProvidedFunctionAppForStaticSite = new StaticSiteUserProvidedFunctionAppForStaticSite("staticSiteUserProvidedFunctionAppForStaticSite", StaticSiteUserProvidedFunctionAppForStaticSiteArgs.builder()
 *             .functionAppName("testFunctionApp")
 *             .functionAppRegion("West US 2")
 *             .functionAppResourceId("/subscription/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/functionRG/providers/Microsoft.Web/sites/testFunctionApp")
 *             .isForced(true)
 *             .name("testStaticSite0")
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:StaticSiteUserProvidedFunctionAppForStaticSite testFunctionApp /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/userProvidedFunctionApps/{functionAppName}
 * ```
 */
public class StaticSiteUserProvidedFunctionAppForStaticSite internal constructor(
    override val javaResource:
    com.pulumi.azurenative.web.StaticSiteUserProvidedFunctionAppForStaticSite,
) : KotlinCustomResource(javaResource, StaticSiteUserProvidedFunctionAppForStaticSiteMapper) {
    /**
     * The date and time on which the function app was registered with the static site.
     */
    public val createdOn: Output<String>
        get() = javaResource.createdOn().applyValue({ args0 -> args0 })

    /**
     * The region of the function app registered with the static site
     */
    public val functionAppRegion: Output<String>?
        get() = javaResource.functionAppRegion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The resource id of the function app registered with the static site
     */
    public val functionAppResourceId: Output<String>?
        get() = javaResource.functionAppResourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Kind of resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object StaticSiteUserProvidedFunctionAppForStaticSiteMapper :
    ResourceMapper<StaticSiteUserProvidedFunctionAppForStaticSite> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.web.StaticSiteUserProvidedFunctionAppForStaticSite::class == javaResource::class

    override fun map(javaResource: Resource): StaticSiteUserProvidedFunctionAppForStaticSite =
        StaticSiteUserProvidedFunctionAppForStaticSite(
            javaResource as
                com.pulumi.azurenative.web.StaticSiteUserProvidedFunctionAppForStaticSite,
        )
}

/**
 * @see [StaticSiteUserProvidedFunctionAppForStaticSite].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StaticSiteUserProvidedFunctionAppForStaticSite].
 */
public suspend fun staticSiteUserProvidedFunctionAppForStaticSite(
    name: String,
    block: suspend StaticSiteUserProvidedFunctionAppForStaticSiteResourceBuilder.() -> Unit,
):
    StaticSiteUserProvidedFunctionAppForStaticSite {
    val builder = StaticSiteUserProvidedFunctionAppForStaticSiteResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StaticSiteUserProvidedFunctionAppForStaticSite].
 * @param name The _unique_ name of the resulting resource.
 */
public fun staticSiteUserProvidedFunctionAppForStaticSite(name: String):
    StaticSiteUserProvidedFunctionAppForStaticSite {
    val builder = StaticSiteUserProvidedFunctionAppForStaticSiteResourceBuilder()
    builder.name(name)
    return builder.build()
}
