@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.WebAppAuthSettingsV2SlotArgs.builder
import com.pulumi.azurenative.web.kotlin.inputs.AuthPlatformArgs
import com.pulumi.azurenative.web.kotlin.inputs.AuthPlatformArgsBuilder
import com.pulumi.azurenative.web.kotlin.inputs.GlobalValidationArgs
import com.pulumi.azurenative.web.kotlin.inputs.GlobalValidationArgsBuilder
import com.pulumi.azurenative.web.kotlin.inputs.HttpSettingsArgs
import com.pulumi.azurenative.web.kotlin.inputs.HttpSettingsArgsBuilder
import com.pulumi.azurenative.web.kotlin.inputs.IdentityProvidersArgs
import com.pulumi.azurenative.web.kotlin.inputs.IdentityProvidersArgsBuilder
import com.pulumi.azurenative.web.kotlin.inputs.LoginArgs
import com.pulumi.azurenative.web.kotlin.inputs.LoginArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Configuration settings for the Azure App Service Authentication / Authorization V2 feature.
 * Azure REST API version: 2021-02-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-10-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppAuthSettingsV2Slot myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/authsettingsV2
 * ```
 * @property globalValidation The configuration settings that determines the validation flow of users using App Service Authentication/Authorization.
 * @property httpSettings The configuration settings of the HTTP requests for authentication and authorization requests made against App Service Authentication/Authorization.
 * @property identityProviders The configuration settings of each of the identity providers used to configure App Service Authentication/Authorization.
 * @property kind Kind of resource.
 * @property login The configuration settings of the login flow of users using App Service Authentication/Authorization.
 * @property name Name of web app.
 * @property platform The configuration settings of the platform of App Service Authentication/Authorization.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property slot Name of web app slot. If not specified then will default to production slot.
 */
public data class WebAppAuthSettingsV2SlotArgs(
    public val globalValidation: Output<GlobalValidationArgs>? = null,
    public val httpSettings: Output<HttpSettingsArgs>? = null,
    public val identityProviders: Output<IdentityProvidersArgs>? = null,
    public val kind: Output<String>? = null,
    public val login: Output<LoginArgs>? = null,
    public val name: Output<String>? = null,
    public val platform: Output<AuthPlatformArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val slot: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.WebAppAuthSettingsV2SlotArgs> {
    override fun toJava(): com.pulumi.azurenative.web.WebAppAuthSettingsV2SlotArgs =
        com.pulumi.azurenative.web.WebAppAuthSettingsV2SlotArgs.builder()
            .globalValidation(globalValidation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .httpSettings(httpSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identityProviders(identityProviders?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .login(login?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .platform(platform?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .slot(slot?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAppAuthSettingsV2SlotArgs].
 */
@PulumiTagMarker
public class WebAppAuthSettingsV2SlotArgsBuilder internal constructor() {
    private var globalValidation: Output<GlobalValidationArgs>? = null

    private var httpSettings: Output<HttpSettingsArgs>? = null

    private var identityProviders: Output<IdentityProvidersArgs>? = null

    private var kind: Output<String>? = null

    private var login: Output<LoginArgs>? = null

    private var name: Output<String>? = null

    private var platform: Output<AuthPlatformArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var slot: Output<String>? = null

    /**
     * @param value The configuration settings that determines the validation flow of users using App Service Authentication/Authorization.
     */
    @JvmName("pmnfpchdiwfejedp")
    public suspend fun globalValidation(`value`: Output<GlobalValidationArgs>) {
        this.globalValidation = value
    }

    /**
     * @param value The configuration settings of the HTTP requests for authentication and authorization requests made against App Service Authentication/Authorization.
     */
    @JvmName("dbargyolfocdveak")
    public suspend fun httpSettings(`value`: Output<HttpSettingsArgs>) {
        this.httpSettings = value
    }

    /**
     * @param value The configuration settings of each of the identity providers used to configure App Service Authentication/Authorization.
     */
    @JvmName("dxytdbgnseruybrp")
    public suspend fun identityProviders(`value`: Output<IdentityProvidersArgs>) {
        this.identityProviders = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("diewjtgpqqbsjyib")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The configuration settings of the login flow of users using App Service Authentication/Authorization.
     */
    @JvmName("ushykbsustoquxfi")
    public suspend fun login(`value`: Output<LoginArgs>) {
        this.login = value
    }

    /**
     * @param value Name of web app.
     */
    @JvmName("rnhrmdtxeusqbiej")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The configuration settings of the platform of App Service Authentication/Authorization.
     */
    @JvmName("kbotxsxqidxkvvdh")
    public suspend fun platform(`value`: Output<AuthPlatformArgs>) {
        this.platform = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("oacwxdqbngivetmx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of web app slot. If not specified then will default to production slot.
     */
    @JvmName("pyoyntaywvdttunm")
    public suspend fun slot(`value`: Output<String>) {
        this.slot = value
    }

    /**
     * @param value The configuration settings that determines the validation flow of users using App Service Authentication/Authorization.
     */
    @JvmName("pqkeseijpfbedbhc")
    public suspend fun globalValidation(`value`: GlobalValidationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.globalValidation = mapped
    }

    /**
     * @param argument The configuration settings that determines the validation flow of users using App Service Authentication/Authorization.
     */
    @JvmName("xhywbdmalyklxqxa")
    public suspend fun globalValidation(argument: suspend GlobalValidationArgsBuilder.() -> Unit) {
        val toBeMapped = GlobalValidationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.globalValidation = mapped
    }

    /**
     * @param value The configuration settings of the HTTP requests for authentication and authorization requests made against App Service Authentication/Authorization.
     */
    @JvmName("srvhfmortvcscahf")
    public suspend fun httpSettings(`value`: HttpSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpSettings = mapped
    }

    /**
     * @param argument The configuration settings of the HTTP requests for authentication and authorization requests made against App Service Authentication/Authorization.
     */
    @JvmName("yaqjolllnfsihppg")
    public suspend fun httpSettings(argument: suspend HttpSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = HttpSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.httpSettings = mapped
    }

    /**
     * @param value The configuration settings of each of the identity providers used to configure App Service Authentication/Authorization.
     */
    @JvmName("gbxmnqpukvbywjyw")
    public suspend fun identityProviders(`value`: IdentityProvidersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityProviders = mapped
    }

    /**
     * @param argument The configuration settings of each of the identity providers used to configure App Service Authentication/Authorization.
     */
    @JvmName("dimppwbhpqppydwa")
    public suspend fun identityProviders(argument: suspend IdentityProvidersArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityProvidersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identityProviders = mapped
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("ptoqocicfdbfljtk")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The configuration settings of the login flow of users using App Service Authentication/Authorization.
     */
    @JvmName("kgbexnslhapmsivx")
    public suspend fun login(`value`: LoginArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.login = mapped
    }

    /**
     * @param argument The configuration settings of the login flow of users using App Service Authentication/Authorization.
     */
    @JvmName("cdhxfajxxkbqknqa")
    public suspend fun login(argument: suspend LoginArgsBuilder.() -> Unit) {
        val toBeMapped = LoginArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.login = mapped
    }

    /**
     * @param value Name of web app.
     */
    @JvmName("sjvxmynynxecsinm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The configuration settings of the platform of App Service Authentication/Authorization.
     */
    @JvmName("prjltefjmuyitlpm")
    public suspend fun platform(`value`: AuthPlatformArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platform = mapped
    }

    /**
     * @param argument The configuration settings of the platform of App Service Authentication/Authorization.
     */
    @JvmName("mbqqdxsulvhvcdkk")
    public suspend fun platform(argument: suspend AuthPlatformArgsBuilder.() -> Unit) {
        val toBeMapped = AuthPlatformArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.platform = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("lyydibeyxbvkbktv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of web app slot. If not specified then will default to production slot.
     */
    @JvmName("ujuxxffegsgnrqbb")
    public suspend fun slot(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slot = mapped
    }

    internal fun build(): WebAppAuthSettingsV2SlotArgs = WebAppAuthSettingsV2SlotArgs(
        globalValidation = globalValidation,
        httpSettings = httpSettings,
        identityProviders = identityProviders,
        kind = kind,
        login = login,
        name = name,
        platform = platform,
        resourceGroupName = resourceGroupName,
        slot = slot,
    )
}
