@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.WebAppBackupConfigurationArgs.builder
import com.pulumi.azurenative.web.kotlin.inputs.BackupScheduleArgs
import com.pulumi.azurenative.web.kotlin.inputs.BackupScheduleArgsBuilder
import com.pulumi.azurenative.web.kotlin.inputs.DatabaseBackupSettingArgs
import com.pulumi.azurenative.web.kotlin.inputs.DatabaseBackupSettingArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Description of a backup which will be performed.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2016-08-01, 2020-10-01, 2023-01-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppBackupConfiguration myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/backup
 * ```
 * @property backupName Name of the backup.
 * @property backupSchedule Schedule for the backup if it is executed periodically.
 * @property databases Databases included in the backup.
 * @property enabled True if the backup schedule is enabled (must be included in that case), false if the backup schedule should be disabled.
 * @property kind Kind of resource.
 * @property name Name of the app.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property storageAccountUrl SAS URL to the container.
 */
public data class WebAppBackupConfigurationArgs(
    public val backupName: Output<String>? = null,
    public val backupSchedule: Output<BackupScheduleArgs>? = null,
    public val databases: Output<List<DatabaseBackupSettingArgs>>? = null,
    public val enabled: Output<Boolean>? = null,
    public val kind: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val storageAccountUrl: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.WebAppBackupConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.web.WebAppBackupConfigurationArgs =
        com.pulumi.azurenative.web.WebAppBackupConfigurationArgs.builder()
            .backupName(backupName?.applyValue({ args0 -> args0 }))
            .backupSchedule(backupSchedule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .databases(
                databases?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .storageAccountUrl(storageAccountUrl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAppBackupConfigurationArgs].
 */
@PulumiTagMarker
public class WebAppBackupConfigurationArgsBuilder internal constructor() {
    private var backupName: Output<String>? = null

    private var backupSchedule: Output<BackupScheduleArgs>? = null

    private var databases: Output<List<DatabaseBackupSettingArgs>>? = null

    private var enabled: Output<Boolean>? = null

    private var kind: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var storageAccountUrl: Output<String>? = null

    /**
     * @param value Name of the backup.
     */
    @JvmName("rrmqxbvgrewabpaw")
    public suspend fun backupName(`value`: Output<String>) {
        this.backupName = value
    }

    /**
     * @param value Schedule for the backup if it is executed periodically.
     */
    @JvmName("vrbnmmwvuaxjcuog")
    public suspend fun backupSchedule(`value`: Output<BackupScheduleArgs>) {
        this.backupSchedule = value
    }

    /**
     * @param value Databases included in the backup.
     */
    @JvmName("hxfolxihthtttouq")
    public suspend fun databases(`value`: Output<List<DatabaseBackupSettingArgs>>) {
        this.databases = value
    }

    @JvmName("wuxlpyxwpxvhpvsg")
    public suspend fun databases(vararg values: Output<DatabaseBackupSettingArgs>) {
        this.databases = Output.all(values.asList())
    }

    /**
     * @param values Databases included in the backup.
     */
    @JvmName("oqyhcxkritiqghan")
    public suspend fun databases(values: List<Output<DatabaseBackupSettingArgs>>) {
        this.databases = Output.all(values)
    }

    /**
     * @param value True if the backup schedule is enabled (must be included in that case), false if the backup schedule should be disabled.
     */
    @JvmName("kmoateujhbqritxl")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("aptapghpftqojtqs")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("jccdwcqmecuoisea")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("ukgbhrerlpqqbuoi")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value SAS URL to the container.
     */
    @JvmName("ywpcrxdaeojhjlco")
    public suspend fun storageAccountUrl(`value`: Output<String>) {
        this.storageAccountUrl = value
    }

    /**
     * @param value Name of the backup.
     */
    @JvmName("yxlalfjuwcktmomh")
    public suspend fun backupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupName = mapped
    }

    /**
     * @param value Schedule for the backup if it is executed periodically.
     */
    @JvmName("flcxsgmxktjknbnx")
    public suspend fun backupSchedule(`value`: BackupScheduleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupSchedule = mapped
    }

    /**
     * @param argument Schedule for the backup if it is executed periodically.
     */
    @JvmName("tuolofmxscustywu")
    public suspend fun backupSchedule(argument: suspend BackupScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = BackupScheduleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.backupSchedule = mapped
    }

    /**
     * @param value Databases included in the backup.
     */
    @JvmName("nswrltonghxxpnnq")
    public suspend fun databases(`value`: List<DatabaseBackupSettingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databases = mapped
    }

    /**
     * @param argument Databases included in the backup.
     */
    @JvmName("drfbqvlxskiwjdwp")
    public suspend
    fun databases(argument: List<suspend DatabaseBackupSettingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DatabaseBackupSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.databases = mapped
    }

    /**
     * @param argument Databases included in the backup.
     */
    @JvmName("mejncoibnnaibvso")
    public suspend fun databases(
        vararg
        argument: suspend DatabaseBackupSettingArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DatabaseBackupSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.databases = mapped
    }

    /**
     * @param argument Databases included in the backup.
     */
    @JvmName("elymteultjkifxwf")
    public suspend fun databases(argument: suspend DatabaseBackupSettingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DatabaseBackupSettingArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.databases = mapped
    }

    /**
     * @param values Databases included in the backup.
     */
    @JvmName("jgivwsymspylthsu")
    public suspend fun databases(vararg values: DatabaseBackupSettingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databases = mapped
    }

    /**
     * @param value True if the backup schedule is enabled (must be included in that case), false if the backup schedule should be disabled.
     */
    @JvmName("pxbiwjyttrthgcoa")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("upmqhlxsjkxemkib")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("obpypvulfixufauu")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("gfvdjglfjvkpflax")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value SAS URL to the container.
     */
    @JvmName("wbivetmtfbvjijpj")
    public suspend fun storageAccountUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountUrl = mapped
    }

    internal fun build(): WebAppBackupConfigurationArgs = WebAppBackupConfigurationArgs(
        backupName = backupName,
        backupSchedule = backupSchedule,
        databases = databases,
        enabled = enabled,
        kind = kind,
        name = name,
        resourceGroupName = resourceGroupName,
        storageAccountUrl = storageAccountUrl,
    )
}
