@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.kotlin.outputs.ConnStringValueTypePairResponse
import com.pulumi.azurenative.web.kotlin.outputs.ConnStringValueTypePairResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [WebAppConnectionStrings].
 */
@PulumiTagMarker
public class WebAppConnectionStringsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebAppConnectionStringsArgs = WebAppConnectionStringsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebAppConnectionStringsArgsBuilder.() -> Unit) {
        val builder = WebAppConnectionStringsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): WebAppConnectionStrings {
        val builtJavaResource =
            com.pulumi.azurenative.web.WebAppConnectionStrings(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WebAppConnectionStrings(builtJavaResource)
    }
}

/**
 * String dictionary resource.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-10-01, 2023-01-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppConnectionStrings myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/connectionstrings
 * ```
 */
public class WebAppConnectionStrings internal constructor(
    override val javaResource: com.pulumi.azurenative.web.WebAppConnectionStrings,
) : KotlinCustomResource(javaResource, WebAppConnectionStringsMapper) {
    /**
     * Kind of resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Connection strings.
     */
    public val properties: Output<Map<String, ConnStringValueTypePairResponse>>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value.let({ args0 -> toKotlin(args0) }))
            }).toMap()
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WebAppConnectionStringsMapper : ResourceMapper<WebAppConnectionStrings> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.web.WebAppConnectionStrings::class == javaResource::class

    override fun map(javaResource: Resource): WebAppConnectionStrings =
        WebAppConnectionStrings(javaResource as com.pulumi.azurenative.web.WebAppConnectionStrings)
}

/**
 * @see [WebAppConnectionStrings].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebAppConnectionStrings].
 */
public suspend fun webAppConnectionStrings(
    name: String,
    block: suspend WebAppConnectionStringsResourceBuilder.() -> Unit,
): WebAppConnectionStrings {
    val builder = WebAppConnectionStringsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebAppConnectionStrings].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webAppConnectionStrings(name: String): WebAppConnectionStrings {
    val builder = WebAppConnectionStringsResourceBuilder()
    builder.name(name)
    return builder.build()
}
