@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.WebAppDiagnosticLogsConfigurationArgs.builder
import com.pulumi.azurenative.web.kotlin.inputs.ApplicationLogsConfigArgs
import com.pulumi.azurenative.web.kotlin.inputs.ApplicationLogsConfigArgsBuilder
import com.pulumi.azurenative.web.kotlin.inputs.EnabledConfigArgs
import com.pulumi.azurenative.web.kotlin.inputs.EnabledConfigArgsBuilder
import com.pulumi.azurenative.web.kotlin.inputs.HttpLogsConfigArgs
import com.pulumi.azurenative.web.kotlin.inputs.HttpLogsConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Configuration of App Service site logs.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-10-01, 2023-01-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppDiagnosticLogsConfiguration myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/logs
 * ```
 * @property applicationLogs Application logs configuration.
 * @property detailedErrorMessages Detailed error messages configuration.
 * @property failedRequestsTracing Failed requests tracing configuration.
 * @property httpLogs HTTP logs configuration.
 * @property kind Kind of resource.
 * @property name Name of the app.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 */
public data class WebAppDiagnosticLogsConfigurationArgs(
    public val applicationLogs: Output<ApplicationLogsConfigArgs>? = null,
    public val detailedErrorMessages: Output<EnabledConfigArgs>? = null,
    public val failedRequestsTracing: Output<EnabledConfigArgs>? = null,
    public val httpLogs: Output<HttpLogsConfigArgs>? = null,
    public val kind: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.WebAppDiagnosticLogsConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.web.WebAppDiagnosticLogsConfigurationArgs =
        com.pulumi.azurenative.web.WebAppDiagnosticLogsConfigurationArgs.builder()
            .applicationLogs(applicationLogs?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .detailedErrorMessages(
                detailedErrorMessages?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .failedRequestsTracing(
                failedRequestsTracing?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .httpLogs(httpLogs?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAppDiagnosticLogsConfigurationArgs].
 */
@PulumiTagMarker
public class WebAppDiagnosticLogsConfigurationArgsBuilder internal constructor() {
    private var applicationLogs: Output<ApplicationLogsConfigArgs>? = null

    private var detailedErrorMessages: Output<EnabledConfigArgs>? = null

    private var failedRequestsTracing: Output<EnabledConfigArgs>? = null

    private var httpLogs: Output<HttpLogsConfigArgs>? = null

    private var kind: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Application logs configuration.
     */
    @JvmName("crahcrwetgnnjscu")
    public suspend fun applicationLogs(`value`: Output<ApplicationLogsConfigArgs>) {
        this.applicationLogs = value
    }

    /**
     * @param value Detailed error messages configuration.
     */
    @JvmName("qabhfhshqebjenqu")
    public suspend fun detailedErrorMessages(`value`: Output<EnabledConfigArgs>) {
        this.detailedErrorMessages = value
    }

    /**
     * @param value Failed requests tracing configuration.
     */
    @JvmName("npcjihtfliaxxwhp")
    public suspend fun failedRequestsTracing(`value`: Output<EnabledConfigArgs>) {
        this.failedRequestsTracing = value
    }

    /**
     * @param value HTTP logs configuration.
     */
    @JvmName("qxofbadnnimtemua")
    public suspend fun httpLogs(`value`: Output<HttpLogsConfigArgs>) {
        this.httpLogs = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("lnfihxoadgvujpix")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("akprcrhoitkehjar")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("dtpcljssmitwhier")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Application logs configuration.
     */
    @JvmName("vtsjdsbelyucawld")
    public suspend fun applicationLogs(`value`: ApplicationLogsConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationLogs = mapped
    }

    /**
     * @param argument Application logs configuration.
     */
    @JvmName("leeleomkcmeffhgh")
    public suspend
    fun applicationLogs(argument: suspend ApplicationLogsConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationLogsConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.applicationLogs = mapped
    }

    /**
     * @param value Detailed error messages configuration.
     */
    @JvmName("sbjnkaxmdudqacsu")
    public suspend fun detailedErrorMessages(`value`: EnabledConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.detailedErrorMessages = mapped
    }

    /**
     * @param argument Detailed error messages configuration.
     */
    @JvmName("ncsakpfaokypugei")
    public suspend fun detailedErrorMessages(argument: suspend EnabledConfigArgsBuilder.() -> Unit) {
        val toBeMapped = EnabledConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.detailedErrorMessages = mapped
    }

    /**
     * @param value Failed requests tracing configuration.
     */
    @JvmName("vubhysdqwfjmkvho")
    public suspend fun failedRequestsTracing(`value`: EnabledConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failedRequestsTracing = mapped
    }

    /**
     * @param argument Failed requests tracing configuration.
     */
    @JvmName("hetfxjebogefrcfr")
    public suspend fun failedRequestsTracing(argument: suspend EnabledConfigArgsBuilder.() -> Unit) {
        val toBeMapped = EnabledConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.failedRequestsTracing = mapped
    }

    /**
     * @param value HTTP logs configuration.
     */
    @JvmName("ejohcewiljdsgcgd")
    public suspend fun httpLogs(`value`: HttpLogsConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpLogs = mapped
    }

    /**
     * @param argument HTTP logs configuration.
     */
    @JvmName("eadvjktfxqtyegge")
    public suspend fun httpLogs(argument: suspend HttpLogsConfigArgsBuilder.() -> Unit) {
        val toBeMapped = HttpLogsConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.httpLogs = mapped
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("osgtpiypjmjegcfc")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("tvqtcshsgqmepsom")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("cncefskldosxwppr")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): WebAppDiagnosticLogsConfigurationArgs =
        WebAppDiagnosticLogsConfigurationArgs(
            applicationLogs = applicationLogs,
            detailedErrorMessages = detailedErrorMessages,
            failedRequestsTracing = failedRequestsTracing,
            httpLogs = httpLogs,
            kind = kind,
            name = name,
            resourceGroupName = resourceGroupName,
        )
}
