@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.WebAppDomainOwnershipIdentifierArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A domain specific resource identifier.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2018-11-01, 2020-10-01, 2023-01-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppDomainOwnershipIdentifier myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}
 * ```
 * @property domainOwnershipIdentifierName Name of domain ownership identifier.
 * @property kind Kind of resource.
 * @property name Name of the app.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property value String representation of the identity.
 */
public data class WebAppDomainOwnershipIdentifierArgs(
    public val domainOwnershipIdentifierName: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.WebAppDomainOwnershipIdentifierArgs> {
    override fun toJava(): com.pulumi.azurenative.web.WebAppDomainOwnershipIdentifierArgs =
        com.pulumi.azurenative.web.WebAppDomainOwnershipIdentifierArgs.builder()
            .domainOwnershipIdentifierName(domainOwnershipIdentifierName?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAppDomainOwnershipIdentifierArgs].
 */
@PulumiTagMarker
public class WebAppDomainOwnershipIdentifierArgsBuilder internal constructor() {
    private var domainOwnershipIdentifierName: Output<String>? = null

    private var kind: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Name of domain ownership identifier.
     */
    @JvmName("qoklrpikkxlltyqe")
    public suspend fun domainOwnershipIdentifierName(`value`: Output<String>) {
        this.domainOwnershipIdentifierName = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("laqwgswxkklfuglx")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("ikhinxxcfasowjpp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("mstxuetsfictmehy")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value String representation of the identity.
     */
    @JvmName("tfhxvjvfwkwkoaap")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Name of domain ownership identifier.
     */
    @JvmName("gmxnpilcgjppcsrs")
    public suspend fun domainOwnershipIdentifierName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainOwnershipIdentifierName = mapped
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("reajdmnlfubtvydi")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("tmkctgvrkhxycjcw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("wrmyckfbnfuuavfw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value String representation of the identity.
     */
    @JvmName("paoucsueidvwbimh")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): WebAppDomainOwnershipIdentifierArgs = WebAppDomainOwnershipIdentifierArgs(
        domainOwnershipIdentifierName = domainOwnershipIdentifierName,
        kind = kind,
        name = name,
        resourceGroupName = resourceGroupName,
        `value` = `value`,
    )
}
