@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.WebAppDomainOwnershipIdentifierSlotArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A domain specific resource identifier.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2018-11-01, 2020-10-01, 2023-01-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppDomainOwnershipIdentifierSlot myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}
 * ```
 * @property domainOwnershipIdentifierName Name of domain ownership identifier.
 * @property kind Kind of resource.
 * @property name Name of the app.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property slot Name of the deployment slot. If a slot is not specified, the API will delete the binding for the production slot.
 * @property value String representation of the identity.
 */
public data class WebAppDomainOwnershipIdentifierSlotArgs(
    public val domainOwnershipIdentifierName: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val slot: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.WebAppDomainOwnershipIdentifierSlotArgs> {
    override fun toJava(): com.pulumi.azurenative.web.WebAppDomainOwnershipIdentifierSlotArgs =
        com.pulumi.azurenative.web.WebAppDomainOwnershipIdentifierSlotArgs.builder()
            .domainOwnershipIdentifierName(domainOwnershipIdentifierName?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .slot(slot?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAppDomainOwnershipIdentifierSlotArgs].
 */
@PulumiTagMarker
public class WebAppDomainOwnershipIdentifierSlotArgsBuilder internal constructor() {
    private var domainOwnershipIdentifierName: Output<String>? = null

    private var kind: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var slot: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Name of domain ownership identifier.
     */
    @JvmName("tmibeeobpsjcarid")
    public suspend fun domainOwnershipIdentifierName(`value`: Output<String>) {
        this.domainOwnershipIdentifierName = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("liwvmqilwuandemk")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("kcnnlwknlwqctbcb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("iimoycfxqgiqbvdw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the deployment slot. If a slot is not specified, the API will delete the binding for the production slot.
     */
    @JvmName("nxphaqxflrrccgjk")
    public suspend fun slot(`value`: Output<String>) {
        this.slot = value
    }

    /**
     * @param value String representation of the identity.
     */
    @JvmName("ntynxfdjttpbytcl")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Name of domain ownership identifier.
     */
    @JvmName("nsnpmnlnsgvvddyo")
    public suspend fun domainOwnershipIdentifierName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainOwnershipIdentifierName = mapped
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("gxooqbxjpdilikuj")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("dmtaodougeuhkcin")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("ninbnlwbjyalopfm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the deployment slot. If a slot is not specified, the API will delete the binding for the production slot.
     */
    @JvmName("dvhgixpgoqooovfq")
    public suspend fun slot(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slot = mapped
    }

    /**
     * @param value String representation of the identity.
     */
    @JvmName("yvnpcosrnkavxodl")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): WebAppDomainOwnershipIdentifierSlotArgs =
        WebAppDomainOwnershipIdentifierSlotArgs(
            domainOwnershipIdentifierName = domainOwnershipIdentifierName,
            kind = kind,
            name = name,
            resourceGroupName = resourceGroupName,
            slot = slot,
            `value` = `value`,
        )
}
