@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.WebAppFunctionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Function information.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2016-08-01, 2020-10-01, 2023-01-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppFunction myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/{functionName}
 * ```
 * @property config Config information.
 * @property configHref Config URI.
 * @property files File list.
 * @property functionAppId Function App ID.
 * @property functionName Function name.
 * @property href Function URI.
 * @property invokeUrlTemplate The invocation URL
 * @property isDisabled Gets or sets a value indicating whether the function is disabled
 * @property kind Kind of resource.
 * @property language The function language
 * @property name Site name.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property scriptHref Script URI.
 * @property scriptRootPathHref Script root path URI.
 * @property secretsFileHref Secrets file URI.
 * @property testData Test data used when testing via the Azure Portal.
 * @property testDataHref Test data URI.
 */
public data class WebAppFunctionArgs(
    public val config: Output<Any>? = null,
    public val configHref: Output<String>? = null,
    public val files: Output<Map<String, String>>? = null,
    public val functionAppId: Output<String>? = null,
    public val functionName: Output<String>? = null,
    public val href: Output<String>? = null,
    public val invokeUrlTemplate: Output<String>? = null,
    public val isDisabled: Output<Boolean>? = null,
    public val kind: Output<String>? = null,
    public val language: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scriptHref: Output<String>? = null,
    public val scriptRootPathHref: Output<String>? = null,
    public val secretsFileHref: Output<String>? = null,
    public val testData: Output<String>? = null,
    public val testDataHref: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.WebAppFunctionArgs> {
    override fun toJava(): com.pulumi.azurenative.web.WebAppFunctionArgs =
        com.pulumi.azurenative.web.WebAppFunctionArgs.builder()
            .config(config?.applyValue({ args0 -> args0 }))
            .configHref(configHref?.applyValue({ args0 -> args0 }))
            .files(files?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .functionAppId(functionAppId?.applyValue({ args0 -> args0 }))
            .functionName(functionName?.applyValue({ args0 -> args0 }))
            .href(href?.applyValue({ args0 -> args0 }))
            .invokeUrlTemplate(invokeUrlTemplate?.applyValue({ args0 -> args0 }))
            .isDisabled(isDisabled?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .language(language?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scriptHref(scriptHref?.applyValue({ args0 -> args0 }))
            .scriptRootPathHref(scriptRootPathHref?.applyValue({ args0 -> args0 }))
            .secretsFileHref(secretsFileHref?.applyValue({ args0 -> args0 }))
            .testData(testData?.applyValue({ args0 -> args0 }))
            .testDataHref(testDataHref?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAppFunctionArgs].
 */
@PulumiTagMarker
public class WebAppFunctionArgsBuilder internal constructor() {
    private var config: Output<Any>? = null

    private var configHref: Output<String>? = null

    private var files: Output<Map<String, String>>? = null

    private var functionAppId: Output<String>? = null

    private var functionName: Output<String>? = null

    private var href: Output<String>? = null

    private var invokeUrlTemplate: Output<String>? = null

    private var isDisabled: Output<Boolean>? = null

    private var kind: Output<String>? = null

    private var language: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var scriptHref: Output<String>? = null

    private var scriptRootPathHref: Output<String>? = null

    private var secretsFileHref: Output<String>? = null

    private var testData: Output<String>? = null

    private var testDataHref: Output<String>? = null

    /**
     * @param value Config information.
     */
    @JvmName("lvkkpkkoqmxriqrn")
    public suspend fun config(`value`: Output<Any>) {
        this.config = value
    }

    /**
     * @param value Config URI.
     */
    @JvmName("ayvtjnixcxbhmjxp")
    public suspend fun configHref(`value`: Output<String>) {
        this.configHref = value
    }

    /**
     * @param value File list.
     */
    @JvmName("vsejuwjmgdjnwkgy")
    public suspend fun files(`value`: Output<Map<String, String>>) {
        this.files = value
    }

    /**
     * @param value Function App ID.
     */
    @JvmName("atejkinjoapaikyx")
    public suspend fun functionAppId(`value`: Output<String>) {
        this.functionAppId = value
    }

    /**
     * @param value Function name.
     */
    @JvmName("ihxecjkanxbgtapq")
    public suspend fun functionName(`value`: Output<String>) {
        this.functionName = value
    }

    /**
     * @param value Function URI.
     */
    @JvmName("hovtinghrakyqkld")
    public suspend fun href(`value`: Output<String>) {
        this.href = value
    }

    /**
     * @param value The invocation URL
     */
    @JvmName("sjvbxgnamjjxlsbj")
    public suspend fun invokeUrlTemplate(`value`: Output<String>) {
        this.invokeUrlTemplate = value
    }

    /**
     * @param value Gets or sets a value indicating whether the function is disabled
     */
    @JvmName("xultdbelaukqbran")
    public suspend fun isDisabled(`value`: Output<Boolean>) {
        this.isDisabled = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("mtihpnguruntvjfp")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The function language
     */
    @JvmName("upsdwhjqjgguaood")
    public suspend fun language(`value`: Output<String>) {
        this.language = value
    }

    /**
     * @param value Site name.
     */
    @JvmName("neefisulbcfpkyee")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("gfavtlnaqtmyasdg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Script URI.
     */
    @JvmName("fwemmojpmcmmsdsd")
    public suspend fun scriptHref(`value`: Output<String>) {
        this.scriptHref = value
    }

    /**
     * @param value Script root path URI.
     */
    @JvmName("etyrqcjmkggdofjm")
    public suspend fun scriptRootPathHref(`value`: Output<String>) {
        this.scriptRootPathHref = value
    }

    /**
     * @param value Secrets file URI.
     */
    @JvmName("vfselmwkctaxnbht")
    public suspend fun secretsFileHref(`value`: Output<String>) {
        this.secretsFileHref = value
    }

    /**
     * @param value Test data used when testing via the Azure Portal.
     */
    @JvmName("sbhusdxyyobqolkl")
    public suspend fun testData(`value`: Output<String>) {
        this.testData = value
    }

    /**
     * @param value Test data URI.
     */
    @JvmName("mfhiawikackopjbv")
    public suspend fun testDataHref(`value`: Output<String>) {
        this.testDataHref = value
    }

    /**
     * @param value Config information.
     */
    @JvmName("aawpxcksktxabpdx")
    public suspend fun config(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.config = mapped
    }

    /**
     * @param value Config URI.
     */
    @JvmName("sabbqbykgtvdfxqt")
    public suspend fun configHref(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configHref = mapped
    }

    /**
     * @param value File list.
     */
    @JvmName("vggrghrutopwkrmo")
    public suspend fun files(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.files = mapped
    }

    /**
     * @param values File list.
     */
    @JvmName("wrqeshbpfgwopdek")
    public fun files(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.files = mapped
    }

    /**
     * @param value Function App ID.
     */
    @JvmName("vvmbakexcdcnccbb")
    public suspend fun functionAppId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionAppId = mapped
    }

    /**
     * @param value Function name.
     */
    @JvmName("wgwecpwjysmrmeoc")
    public suspend fun functionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionName = mapped
    }

    /**
     * @param value Function URI.
     */
    @JvmName("rmuqtolgsnqawpsk")
    public suspend fun href(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.href = mapped
    }

    /**
     * @param value The invocation URL
     */
    @JvmName("ycdcbryaoxistdnw")
    public suspend fun invokeUrlTemplate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.invokeUrlTemplate = mapped
    }

    /**
     * @param value Gets or sets a value indicating whether the function is disabled
     */
    @JvmName("fhctwrcwbxecwifr")
    public suspend fun isDisabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isDisabled = mapped
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("ssqgmutdyfrvrrpv")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The function language
     */
    @JvmName("hysqhpwrayqvnwbx")
    public suspend fun language(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.language = mapped
    }

    /**
     * @param value Site name.
     */
    @JvmName("ylyackdmsbxlnjfu")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("pkvhfifyxssilwya")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Script URI.
     */
    @JvmName("mqgjqfyayamgaahl")
    public suspend fun scriptHref(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scriptHref = mapped
    }

    /**
     * @param value Script root path URI.
     */
    @JvmName("nfewtuvwedctsuqp")
    public suspend fun scriptRootPathHref(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scriptRootPathHref = mapped
    }

    /**
     * @param value Secrets file URI.
     */
    @JvmName("lpacurghvrxdbtgw")
    public suspend fun secretsFileHref(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretsFileHref = mapped
    }

    /**
     * @param value Test data used when testing via the Azure Portal.
     */
    @JvmName("jmuxtnmnykalijjn")
    public suspend fun testData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.testData = mapped
    }

    /**
     * @param value Test data URI.
     */
    @JvmName("eyynvkdkyoirmscm")
    public suspend fun testDataHref(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.testDataHref = mapped
    }

    internal fun build(): WebAppFunctionArgs = WebAppFunctionArgs(
        config = config,
        configHref = configHref,
        files = files,
        functionAppId = functionAppId,
        functionName = functionName,
        href = href,
        invokeUrlTemplate = invokeUrlTemplate,
        isDisabled = isDisabled,
        kind = kind,
        language = language,
        name = name,
        resourceGroupName = resourceGroupName,
        scriptHref = scriptHref,
        scriptRootPathHref = scriptRootPathHref,
        secretsFileHref = secretsFileHref,
        testData = testData,
        testDataHref = testDataHref,
    )
}
