@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.WebAppHybridConnectionSlotArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Hybrid Connection contract. This is used to configure a Hybrid Connection.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-10-01, 2023-01-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppHybridConnectionSlot myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}
 * ```
 * @property hostname The hostname of the endpoint.
 * @property kind Kind of resource.
 * @property name The name of the web app.
 * @property namespaceName The namespace for this hybrid connection.
 * @property port The port of the endpoint.
 * @property relayArmUri The ARM URI to the Service Bus relay.
 * @property relayName The name of the Service Bus relay.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property sendKeyName The name of the Service Bus key which has Send permissions. This is used to authenticate to Service Bus.
 * @property sendKeyValue The value of the Service Bus key. This is used to authenticate to Service Bus. In ARM this key will not be returned
 * normally, use the POST /listKeys API instead.
 * @property serviceBusNamespace The name of the Service Bus namespace.
 * @property serviceBusSuffix The suffix for the service bus endpoint. By default this is .servicebus.windows.net
 * @property slot The name of the slot for the web app.
 */
public data class WebAppHybridConnectionSlotArgs(
    public val hostname: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val name: Output<String>? = null,
    public val namespaceName: Output<String>? = null,
    public val port: Output<Int>? = null,
    public val relayArmUri: Output<String>? = null,
    public val relayName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sendKeyName: Output<String>? = null,
    public val sendKeyValue: Output<String>? = null,
    public val serviceBusNamespace: Output<String>? = null,
    public val serviceBusSuffix: Output<String>? = null,
    public val slot: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.WebAppHybridConnectionSlotArgs> {
    override fun toJava(): com.pulumi.azurenative.web.WebAppHybridConnectionSlotArgs =
        com.pulumi.azurenative.web.WebAppHybridConnectionSlotArgs.builder()
            .hostname(hostname?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .relayArmUri(relayArmUri?.applyValue({ args0 -> args0 }))
            .relayName(relayName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sendKeyName(sendKeyName?.applyValue({ args0 -> args0 }))
            .sendKeyValue(sendKeyValue?.applyValue({ args0 -> args0 }))
            .serviceBusNamespace(serviceBusNamespace?.applyValue({ args0 -> args0 }))
            .serviceBusSuffix(serviceBusSuffix?.applyValue({ args0 -> args0 }))
            .slot(slot?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAppHybridConnectionSlotArgs].
 */
@PulumiTagMarker
public class WebAppHybridConnectionSlotArgsBuilder internal constructor() {
    private var hostname: Output<String>? = null

    private var kind: Output<String>? = null

    private var name: Output<String>? = null

    private var namespaceName: Output<String>? = null

    private var port: Output<Int>? = null

    private var relayArmUri: Output<String>? = null

    private var relayName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sendKeyName: Output<String>? = null

    private var sendKeyValue: Output<String>? = null

    private var serviceBusNamespace: Output<String>? = null

    private var serviceBusSuffix: Output<String>? = null

    private var slot: Output<String>? = null

    /**
     * @param value The hostname of the endpoint.
     */
    @JvmName("wetutlvijoqfkgyt")
    public suspend fun hostname(`value`: Output<String>) {
        this.hostname = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("qaenurkkddauaaxm")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The name of the web app.
     */
    @JvmName("tjeqhfyncyddeukl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The namespace for this hybrid connection.
     */
    @JvmName("xekmqyovpsuqppfg")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value The port of the endpoint.
     */
    @JvmName("sletjfyvgsaxjkdj")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The ARM URI to the Service Bus relay.
     */
    @JvmName("hhpjlitpmhxywexh")
    public suspend fun relayArmUri(`value`: Output<String>) {
        this.relayArmUri = value
    }

    /**
     * @param value The name of the Service Bus relay.
     */
    @JvmName("rvqimhtfgysbswqx")
    public suspend fun relayName(`value`: Output<String>) {
        this.relayName = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("cffefjcqrumrgpqo")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Service Bus key which has Send permissions. This is used to authenticate to Service Bus.
     */
    @JvmName("akjjklxwwkwmvyks")
    public suspend fun sendKeyName(`value`: Output<String>) {
        this.sendKeyName = value
    }

    /**
     * @param value The value of the Service Bus key. This is used to authenticate to Service Bus. In ARM this key will not be returned
     * normally, use the POST /listKeys API instead.
     */
    @JvmName("uiftvuuqlxlpliyf")
    public suspend fun sendKeyValue(`value`: Output<String>) {
        this.sendKeyValue = value
    }

    /**
     * @param value The name of the Service Bus namespace.
     */
    @JvmName("kmpfdnqdxfdqdvoe")
    public suspend fun serviceBusNamespace(`value`: Output<String>) {
        this.serviceBusNamespace = value
    }

    /**
     * @param value The suffix for the service bus endpoint. By default this is .servicebus.windows.net
     */
    @JvmName("ltulgxplqhaivuin")
    public suspend fun serviceBusSuffix(`value`: Output<String>) {
        this.serviceBusSuffix = value
    }

    /**
     * @param value The name of the slot for the web app.
     */
    @JvmName("gpkunlneebjuyiym")
    public suspend fun slot(`value`: Output<String>) {
        this.slot = value
    }

    /**
     * @param value The hostname of the endpoint.
     */
    @JvmName("iirolmxufhhutldr")
    public suspend fun hostname(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostname = mapped
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("ccgddewffuxhwuya")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The name of the web app.
     */
    @JvmName("wsqvheqompbcykum")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The namespace for this hybrid connection.
     */
    @JvmName("sdiheandbejxdqpa")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    /**
     * @param value The port of the endpoint.
     */
    @JvmName("avfudvlqlinaffhh")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The ARM URI to the Service Bus relay.
     */
    @JvmName("bvoyxdaklxrscnna")
    public suspend fun relayArmUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relayArmUri = mapped
    }

    /**
     * @param value The name of the Service Bus relay.
     */
    @JvmName("dbbeqqjmnqcmuebx")
    public suspend fun relayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relayName = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("bvsjcqdnyefvuacd")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Service Bus key which has Send permissions. This is used to authenticate to Service Bus.
     */
    @JvmName("vaexkyufvfsinciq")
    public suspend fun sendKeyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sendKeyName = mapped
    }

    /**
     * @param value The value of the Service Bus key. This is used to authenticate to Service Bus. In ARM this key will not be returned
     * normally, use the POST /listKeys API instead.
     */
    @JvmName("cnchhjcbiisoytjs")
    public suspend fun sendKeyValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sendKeyValue = mapped
    }

    /**
     * @param value The name of the Service Bus namespace.
     */
    @JvmName("eervennjfytdqiyl")
    public suspend fun serviceBusNamespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceBusNamespace = mapped
    }

    /**
     * @param value The suffix for the service bus endpoint. By default this is .servicebus.windows.net
     */
    @JvmName("jgbjilkqrskflthm")
    public suspend fun serviceBusSuffix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceBusSuffix = mapped
    }

    /**
     * @param value The name of the slot for the web app.
     */
    @JvmName("uveajjlivyuxmoot")
    public suspend fun slot(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slot = mapped
    }

    internal fun build(): WebAppHybridConnectionSlotArgs = WebAppHybridConnectionSlotArgs(
        hostname = hostname,
        kind = kind,
        name = name,
        namespaceName = namespaceName,
        port = port,
        relayArmUri = relayArmUri,
        relayName = relayName,
        resourceGroupName = resourceGroupName,
        sendKeyName = sendKeyName,
        sendKeyValue = sendKeyValue,
        serviceBusNamespace = serviceBusNamespace,
        serviceBusSuffix = serviceBusSuffix,
        slot = slot,
    )
}
