@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [WebAppInstanceFunctionSlot].
 */
@PulumiTagMarker
public class WebAppInstanceFunctionSlotResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebAppInstanceFunctionSlotArgs = WebAppInstanceFunctionSlotArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebAppInstanceFunctionSlotArgsBuilder.() -> Unit) {
        val builder = WebAppInstanceFunctionSlotArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): WebAppInstanceFunctionSlot {
        val builtJavaResource =
            com.pulumi.azurenative.web.WebAppInstanceFunctionSlot(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WebAppInstanceFunctionSlot(builtJavaResource)
    }
}

/**
 * Function information.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2016-08-01, 2020-10-01, 2023-01-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppInstanceFunctionSlot myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions/{functionName}
 * ```
 */
public class WebAppInstanceFunctionSlot internal constructor(
    override val javaResource: com.pulumi.azurenative.web.WebAppInstanceFunctionSlot,
) : KotlinCustomResource(javaResource, WebAppInstanceFunctionSlotMapper) {
    /**
     * Config information.
     */
    public val config: Output<Any>?
        get() = javaResource.config().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Config URI.
     */
    public val configHref: Output<String>?
        get() = javaResource.configHref().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * File list.
     */
    public val files: Output<Map<String, String>>?
        get() = javaResource.files().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Function App ID.
     */
    public val functionAppId: Output<String>?
        get() = javaResource.functionAppId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Function URI.
     */
    public val href: Output<String>?
        get() = javaResource.href().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The invocation URL
     */
    public val invokeUrlTemplate: Output<String>?
        get() = javaResource.invokeUrlTemplate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets a value indicating whether the function is disabled
     */
    public val isDisabled: Output<Boolean>?
        get() = javaResource.isDisabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Kind of resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The function language
     */
    public val language: Output<String>?
        get() = javaResource.language().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Script URI.
     */
    public val scriptHref: Output<String>?
        get() = javaResource.scriptHref().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Script root path URI.
     */
    public val scriptRootPathHref: Output<String>?
        get() = javaResource.scriptRootPathHref().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Secrets file URI.
     */
    public val secretsFileHref: Output<String>?
        get() = javaResource.secretsFileHref().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Test data used when testing via the Azure Portal.
     */
    public val testData: Output<String>?
        get() = javaResource.testData().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Test data URI.
     */
    public val testDataHref: Output<String>?
        get() = javaResource.testDataHref().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WebAppInstanceFunctionSlotMapper : ResourceMapper<WebAppInstanceFunctionSlot> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.web.WebAppInstanceFunctionSlot::class == javaResource::class

    override fun map(javaResource: Resource): WebAppInstanceFunctionSlot =
        WebAppInstanceFunctionSlot(
            javaResource as
                com.pulumi.azurenative.web.WebAppInstanceFunctionSlot,
        )
}

/**
 * @see [WebAppInstanceFunctionSlot].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebAppInstanceFunctionSlot].
 */
public suspend fun webAppInstanceFunctionSlot(
    name: String,
    block: suspend WebAppInstanceFunctionSlotResourceBuilder.() -> Unit,
):
    WebAppInstanceFunctionSlot {
    val builder = WebAppInstanceFunctionSlotResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebAppInstanceFunctionSlot].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webAppInstanceFunctionSlot(name: String): WebAppInstanceFunctionSlot {
    val builder = WebAppInstanceFunctionSlotResourceBuilder()
    builder.name(name)
    return builder.build()
}
