@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.WebAppMetadataSlotArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * String dictionary resource.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-10-01, 2023-01-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppMetadataSlot myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/metadata
 * ```
 * @property kind Kind of resource.
 * @property name Name of the app.
 * @property properties Settings.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property slot Name of the deployment slot. If a slot is not specified, the API will update the metadata for the production slot.
 */
public data class WebAppMetadataSlotArgs(
    public val kind: Output<String>? = null,
    public val name: Output<String>? = null,
    public val properties: Output<Map<String, String>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val slot: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.WebAppMetadataSlotArgs> {
    override fun toJava(): com.pulumi.azurenative.web.WebAppMetadataSlotArgs =
        com.pulumi.azurenative.web.WebAppMetadataSlotArgs.builder()
            .kind(kind?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .slot(slot?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAppMetadataSlotArgs].
 */
@PulumiTagMarker
public class WebAppMetadataSlotArgsBuilder internal constructor() {
    private var kind: Output<String>? = null

    private var name: Output<String>? = null

    private var properties: Output<Map<String, String>>? = null

    private var resourceGroupName: Output<String>? = null

    private var slot: Output<String>? = null

    /**
     * @param value Kind of resource.
     */
    @JvmName("xutcvwrleyrwcfjr")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("lendqhrpowrgiesk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Settings.
     */
    @JvmName("tcqwdgingsbyolys")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("hbtwsyijbcffcgkp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the deployment slot. If a slot is not specified, the API will update the metadata for the production slot.
     */
    @JvmName("ubleydkixdedqwou")
    public suspend fun slot(`value`: Output<String>) {
        this.slot = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("lyftefhrxlafysdc")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("jopewilwparaoevn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Settings.
     */
    @JvmName("hhxemflxvfyfuduy")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values Settings.
     */
    @JvmName("tjndvtyajlvusqjx")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("uyvvniitkdaaursi")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the deployment slot. If a slot is not specified, the API will update the metadata for the production slot.
     */
    @JvmName("oprnvrmodbccbqmk")
    public suspend fun slot(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slot = mapped
    }

    internal fun build(): WebAppMetadataSlotArgs = WebAppMetadataSlotArgs(
        kind = kind,
        name = name,
        properties = properties,
        resourceGroupName = resourceGroupName,
        slot = slot,
    )
}
