@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.WebAppPremierAddOnSlotArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Premier add-on.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2016-08-01, 2020-10-01, 2023-01-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppPremierAddOnSlot myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons/{premierAddOnName}
 * ```
 * @property kind Kind of resource.
 * @property location Resource Location.
 * @property marketplaceOffer Premier add on Marketplace offer.
 * @property marketplacePublisher Premier add on Marketplace publisher.
 * @property name Name of the app.
 * @property premierAddOnName Add-on name.
 * @property product Premier add on Product.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property sku Premier add on SKU.
 * @property slot Name of the deployment slot. If a slot is not specified, the API will update the named add-on for the production slot.
 * @property tags Resource tags.
 * @property vendor Premier add on Vendor.
 */
public data class WebAppPremierAddOnSlotArgs(
    public val kind: Output<String>? = null,
    public val location: Output<String>? = null,
    public val marketplaceOffer: Output<String>? = null,
    public val marketplacePublisher: Output<String>? = null,
    public val name: Output<String>? = null,
    public val premierAddOnName: Output<String>? = null,
    public val product: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<String>? = null,
    public val slot: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vendor: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.WebAppPremierAddOnSlotArgs> {
    override fun toJava(): com.pulumi.azurenative.web.WebAppPremierAddOnSlotArgs =
        com.pulumi.azurenative.web.WebAppPremierAddOnSlotArgs.builder()
            .kind(kind?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .marketplaceOffer(marketplaceOffer?.applyValue({ args0 -> args0 }))
            .marketplacePublisher(marketplacePublisher?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .premierAddOnName(premierAddOnName?.applyValue({ args0 -> args0 }))
            .product(product?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0 }))
            .slot(slot?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vendor(vendor?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAppPremierAddOnSlotArgs].
 */
@PulumiTagMarker
public class WebAppPremierAddOnSlotArgsBuilder internal constructor() {
    private var kind: Output<String>? = null

    private var location: Output<String>? = null

    private var marketplaceOffer: Output<String>? = null

    private var marketplacePublisher: Output<String>? = null

    private var name: Output<String>? = null

    private var premierAddOnName: Output<String>? = null

    private var product: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<String>? = null

    private var slot: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vendor: Output<String>? = null

    /**
     * @param value Kind of resource.
     */
    @JvmName("bnelrcmjoyvneupe")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Resource Location.
     */
    @JvmName("qlikxprvtlpktpai")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Premier add on Marketplace offer.
     */
    @JvmName("yatlvsacsomfapwu")
    public suspend fun marketplaceOffer(`value`: Output<String>) {
        this.marketplaceOffer = value
    }

    /**
     * @param value Premier add on Marketplace publisher.
     */
    @JvmName("kdggsmvodycsrqun")
    public suspend fun marketplacePublisher(`value`: Output<String>) {
        this.marketplacePublisher = value
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("otxuwhsvrhebxnel")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Add-on name.
     */
    @JvmName("qpycwngjlswklvdu")
    public suspend fun premierAddOnName(`value`: Output<String>) {
        this.premierAddOnName = value
    }

    /**
     * @param value Premier add on Product.
     */
    @JvmName("tjtrirvbcjqusgpt")
    public suspend fun product(`value`: Output<String>) {
        this.product = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("mnbyxmtwtvpivndd")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Premier add on SKU.
     */
    @JvmName("aocvqvcpoiaalshe")
    public suspend fun sku(`value`: Output<String>) {
        this.sku = value
    }

    /**
     * @param value Name of the deployment slot. If a slot is not specified, the API will update the named add-on for the production slot.
     */
    @JvmName("saysbpiveikdijpj")
    public suspend fun slot(`value`: Output<String>) {
        this.slot = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("lycapykkdkrbemcm")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Premier add on Vendor.
     */
    @JvmName("obfhnpurenrayfuh")
    public suspend fun vendor(`value`: Output<String>) {
        this.vendor = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("rfouiindaqpogsyb")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Resource Location.
     */
    @JvmName("iwjedgqgtdxrjxtn")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Premier add on Marketplace offer.
     */
    @JvmName("qvosudaxbswelmft")
    public suspend fun marketplaceOffer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.marketplaceOffer = mapped
    }

    /**
     * @param value Premier add on Marketplace publisher.
     */
    @JvmName("sbnxjjnehlhmcprx")
    public suspend fun marketplacePublisher(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.marketplacePublisher = mapped
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("hitnfuddwhcrobvi")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Add-on name.
     */
    @JvmName("eyhqckqobvtxcnpi")
    public suspend fun premierAddOnName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.premierAddOnName = mapped
    }

    /**
     * @param value Premier add on Product.
     */
    @JvmName("vnqcvwyuqeqkpkdv")
    public suspend fun product(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.product = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("njgupeesspnwjkbt")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Premier add on SKU.
     */
    @JvmName("lbrfbrsgkdryivqy")
    public suspend fun sku(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param value Name of the deployment slot. If a slot is not specified, the API will update the named add-on for the production slot.
     */
    @JvmName("iatxdfseomhiftvk")
    public suspend fun slot(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slot = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("gaiinuvhgkosglxt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("qcjiewgwurjbwlxm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Premier add on Vendor.
     */
    @JvmName("jdnrxlwlulofvgyx")
    public suspend fun vendor(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vendor = mapped
    }

    internal fun build(): WebAppPremierAddOnSlotArgs = WebAppPremierAddOnSlotArgs(
        kind = kind,
        location = location,
        marketplaceOffer = marketplaceOffer,
        marketplacePublisher = marketplacePublisher,
        name = name,
        premierAddOnName = premierAddOnName,
        product = product,
        resourceGroupName = resourceGroupName,
        sku = sku,
        slot = slot,
        tags = tags,
        vendor = vendor,
    )
}
