@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.WebAppSiteExtensionSlotArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Site Extension Information.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2016-08-01, 2020-10-01, 2023-01-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppSiteExtensionSlot myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/siteextensions/{siteExtensionId}
 * ```
 * @property name Site name.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property siteExtensionId Site extension name.
 * @property slot Name of the deployment slot. If a slot is not specified, the API uses the production slot.
 */
public data class WebAppSiteExtensionSlotArgs(
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val siteExtensionId: Output<String>? = null,
    public val slot: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.WebAppSiteExtensionSlotArgs> {
    override fun toJava(): com.pulumi.azurenative.web.WebAppSiteExtensionSlotArgs =
        com.pulumi.azurenative.web.WebAppSiteExtensionSlotArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .siteExtensionId(siteExtensionId?.applyValue({ args0 -> args0 }))
            .slot(slot?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAppSiteExtensionSlotArgs].
 */
@PulumiTagMarker
public class WebAppSiteExtensionSlotArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var siteExtensionId: Output<String>? = null

    private var slot: Output<String>? = null

    /**
     * @param value Site name.
     */
    @JvmName("chxtaayqunoajcyw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("upavkcftdnsylxuv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Site extension name.
     */
    @JvmName("mmvqlfeuvjtlsjkh")
    public suspend fun siteExtensionId(`value`: Output<String>) {
        this.siteExtensionId = value
    }

    /**
     * @param value Name of the deployment slot. If a slot is not specified, the API uses the production slot.
     */
    @JvmName("kkmxcdrujnrdvduf")
    public suspend fun slot(`value`: Output<String>) {
        this.slot = value
    }

    /**
     * @param value Site name.
     */
    @JvmName("bnauvefycooorlvs")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("phoulxlmgthpbojp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Site extension name.
     */
    @JvmName("sfnwtuyybkvalycu")
    public suspend fun siteExtensionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.siteExtensionId = mapped
    }

    /**
     * @param value Name of the deployment slot. If a slot is not specified, the API uses the production slot.
     */
    @JvmName("aihmxadwubuaclqj")
    public suspend fun slot(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slot = mapped
    }

    internal fun build(): WebAppSiteExtensionSlotArgs = WebAppSiteExtensionSlotArgs(
        name = name,
        resourceGroupName = resourceGroupName,
        siteExtensionId = siteExtensionId,
        slot = slot,
    )
}
