@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.WebAppSourceControlArgs.builder
import com.pulumi.azurenative.web.kotlin.inputs.GitHubActionConfigurationArgs
import com.pulumi.azurenative.web.kotlin.inputs.GitHubActionConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Source control configuration for an app.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-10-01, 2023-01-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppSourceControl myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sourcecontrols/web
 * ```
 * @property branch Name of branch to use for deployment.
 * @property deploymentRollbackEnabled <code>true</code> to enable deployment rollback; otherwise, <code>false</code>.
 * @property gitHubActionConfiguration If GitHub Action is selected, than the associated configuration.
 * @property isGitHubAction <code>true</code> if this is deployed via GitHub action.
 * @property isManualIntegration <code>true</code> to limit to manual integration; <code>false</code> to enable continuous integration (which configures webhooks into online repos like GitHub).
 * @property isMercurial <code>true</code> for a Mercurial repository; <code>false</code> for a Git repository.
 * @property kind Kind of resource.
 * @property name Name of the app.
 * @property repoUrl Repository or source control URL.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 */
public data class WebAppSourceControlArgs(
    public val branch: Output<String>? = null,
    public val deploymentRollbackEnabled: Output<Boolean>? = null,
    public val gitHubActionConfiguration: Output<GitHubActionConfigurationArgs>? = null,
    public val isGitHubAction: Output<Boolean>? = null,
    public val isManualIntegration: Output<Boolean>? = null,
    public val isMercurial: Output<Boolean>? = null,
    public val kind: Output<String>? = null,
    public val name: Output<String>? = null,
    public val repoUrl: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.WebAppSourceControlArgs> {
    override fun toJava(): com.pulumi.azurenative.web.WebAppSourceControlArgs =
        com.pulumi.azurenative.web.WebAppSourceControlArgs.builder()
            .branch(branch?.applyValue({ args0 -> args0 }))
            .deploymentRollbackEnabled(deploymentRollbackEnabled?.applyValue({ args0 -> args0 }))
            .gitHubActionConfiguration(
                gitHubActionConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .isGitHubAction(isGitHubAction?.applyValue({ args0 -> args0 }))
            .isManualIntegration(isManualIntegration?.applyValue({ args0 -> args0 }))
            .isMercurial(isMercurial?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .repoUrl(repoUrl?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAppSourceControlArgs].
 */
@PulumiTagMarker
public class WebAppSourceControlArgsBuilder internal constructor() {
    private var branch: Output<String>? = null

    private var deploymentRollbackEnabled: Output<Boolean>? = null

    private var gitHubActionConfiguration: Output<GitHubActionConfigurationArgs>? = null

    private var isGitHubAction: Output<Boolean>? = null

    private var isManualIntegration: Output<Boolean>? = null

    private var isMercurial: Output<Boolean>? = null

    private var kind: Output<String>? = null

    private var name: Output<String>? = null

    private var repoUrl: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Name of branch to use for deployment.
     */
    @JvmName("kumhepnfeqysyeki")
    public suspend fun branch(`value`: Output<String>) {
        this.branch = value
    }

    /**
     * @param value <code>true</code> to enable deployment rollback; otherwise, <code>false</code>.
     */
    @JvmName("ktbdghweuumkstkv")
    public suspend fun deploymentRollbackEnabled(`value`: Output<Boolean>) {
        this.deploymentRollbackEnabled = value
    }

    /**
     * @param value If GitHub Action is selected, than the associated configuration.
     */
    @JvmName("lnbmpqoixigtqxhy")
    public suspend fun gitHubActionConfiguration(`value`: Output<GitHubActionConfigurationArgs>) {
        this.gitHubActionConfiguration = value
    }

    /**
     * @param value <code>true</code> if this is deployed via GitHub action.
     */
    @JvmName("oxwboqhbrtmxcjos")
    public suspend fun isGitHubAction(`value`: Output<Boolean>) {
        this.isGitHubAction = value
    }

    /**
     * @param value <code>true</code> to limit to manual integration; <code>false</code> to enable continuous integration (which configures webhooks into online repos like GitHub).
     */
    @JvmName("ksimmnymglqdcajk")
    public suspend fun isManualIntegration(`value`: Output<Boolean>) {
        this.isManualIntegration = value
    }

    /**
     * @param value <code>true</code> for a Mercurial repository; <code>false</code> for a Git repository.
     */
    @JvmName("fkbqqwanmwtpaaid")
    public suspend fun isMercurial(`value`: Output<Boolean>) {
        this.isMercurial = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("xkaadicntqppgknh")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("btfgbdcidehfaqig")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Repository or source control URL.
     */
    @JvmName("wvtclukawydfcmfg")
    public suspend fun repoUrl(`value`: Output<String>) {
        this.repoUrl = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("uvtstwahppjtykql")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of branch to use for deployment.
     */
    @JvmName("dxramrjaegkhctps")
    public suspend fun branch(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.branch = mapped
    }

    /**
     * @param value <code>true</code> to enable deployment rollback; otherwise, <code>false</code>.
     */
    @JvmName("rxxfrxdpyekwcfuw")
    public suspend fun deploymentRollbackEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentRollbackEnabled = mapped
    }

    /**
     * @param value If GitHub Action is selected, than the associated configuration.
     */
    @JvmName("veurkpmwnnkxwahi")
    public suspend fun gitHubActionConfiguration(`value`: GitHubActionConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gitHubActionConfiguration = mapped
    }

    /**
     * @param argument If GitHub Action is selected, than the associated configuration.
     */
    @JvmName("uitmecfvpmesnjkm")
    public suspend
    fun gitHubActionConfiguration(argument: suspend GitHubActionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = GitHubActionConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.gitHubActionConfiguration = mapped
    }

    /**
     * @param value <code>true</code> if this is deployed via GitHub action.
     */
    @JvmName("tilmqechmvdypdxo")
    public suspend fun isGitHubAction(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isGitHubAction = mapped
    }

    /**
     * @param value <code>true</code> to limit to manual integration; <code>false</code> to enable continuous integration (which configures webhooks into online repos like GitHub).
     */
    @JvmName("yrmwirtajuonocrb")
    public suspend fun isManualIntegration(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isManualIntegration = mapped
    }

    /**
     * @param value <code>true</code> for a Mercurial repository; <code>false</code> for a Git repository.
     */
    @JvmName("dancsieyuniapkfd")
    public suspend fun isMercurial(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isMercurial = mapped
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("tkaejmffprpoannv")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("xningmnboyuewtnp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Repository or source control URL.
     */
    @JvmName("flmscafkjgomfyid")
    public suspend fun repoUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repoUrl = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("iwacbobgikjcjlnc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): WebAppSourceControlArgs = WebAppSourceControlArgs(
        branch = branch,
        deploymentRollbackEnabled = deploymentRollbackEnabled,
        gitHubActionConfiguration = gitHubActionConfiguration,
        isGitHubAction = isGitHubAction,
        isManualIntegration = isManualIntegration,
        isMercurial = isMercurial,
        kind = kind,
        name = name,
        repoUrl = repoUrl,
        resourceGroupName = resourceGroupName,
    )
}
