@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.WebAppSwiftVirtualNetworkConnectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Swift Virtual Network Contract. This is used to enable the new Swift way of doing virtual network integration.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-10-01.
 * Other available API versions: 2020-10-01, 2023-01-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppSwiftVirtualNetworkConnection myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkConfig/virtualNetwork
 * ```
 * @property kind Kind of resource.
 * @property name Name of the app.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property subnetResourceId The Virtual Network subnet's resource ID. This is the subnet that this Web App will join. This subnet must have a delegation to Microsoft.Web/serverFarms defined first.
 * @property swiftSupported A flag that specifies if the scale unit this Web App is on supports Swift integration.
 */
public data class WebAppSwiftVirtualNetworkConnectionArgs(
    public val kind: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val subnetResourceId: Output<String>? = null,
    public val swiftSupported: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.WebAppSwiftVirtualNetworkConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.web.WebAppSwiftVirtualNetworkConnectionArgs =
        com.pulumi.azurenative.web.WebAppSwiftVirtualNetworkConnectionArgs.builder()
            .kind(kind?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .subnetResourceId(subnetResourceId?.applyValue({ args0 -> args0 }))
            .swiftSupported(swiftSupported?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAppSwiftVirtualNetworkConnectionArgs].
 */
@PulumiTagMarker
public class WebAppSwiftVirtualNetworkConnectionArgsBuilder internal constructor() {
    private var kind: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var subnetResourceId: Output<String>? = null

    private var swiftSupported: Output<Boolean>? = null

    /**
     * @param value Kind of resource.
     */
    @JvmName("qnoldvjbfifraohn")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("pqmobudqfjxwslpl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("qlxcxxghdbkvrroi")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The Virtual Network subnet's resource ID. This is the subnet that this Web App will join. This subnet must have a delegation to Microsoft.Web/serverFarms defined first.
     */
    @JvmName("tlqknqlfogdppccc")
    public suspend fun subnetResourceId(`value`: Output<String>) {
        this.subnetResourceId = value
    }

    /**
     * @param value A flag that specifies if the scale unit this Web App is on supports Swift integration.
     */
    @JvmName("qenwipnahdgvmitg")
    public suspend fun swiftSupported(`value`: Output<Boolean>) {
        this.swiftSupported = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("apsqhdrplxlwdgsx")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("jxgoaidncbpbkkpn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("bkiyroegunnpetxf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The Virtual Network subnet's resource ID. This is the subnet that this Web App will join. This subnet must have a delegation to Microsoft.Web/serverFarms defined first.
     */
    @JvmName("tmvnmxxowtbnipaq")
    public suspend fun subnetResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetResourceId = mapped
    }

    /**
     * @param value A flag that specifies if the scale unit this Web App is on supports Swift integration.
     */
    @JvmName("skjtrqhovglcouow")
    public suspend fun swiftSupported(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.swiftSupported = mapped
    }

    internal fun build(): WebAppSwiftVirtualNetworkConnectionArgs =
        WebAppSwiftVirtualNetworkConnectionArgs(
            kind = kind,
            name = name,
            resourceGroupName = resourceGroupName,
            subnetResourceId = subnetResourceId,
            swiftSupported = swiftSupported,
        )
}
